% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_squared_sel.R
\name{plot_squared_sel}
\alias{plot_squared_sel}
\title{Plot the graph of the squared scaled expected length
of the CIUUPI}
\usage{
plot_squared_sel(bs.list)
}
\arguments{
\item{bs.list}{A list that includes the following
components.

\code{alpha}: the desired minimum coverage is \eqn{1 - \alpha}.

\code{rho}: the known correlation
between \eqn{\widehat{\theta}}
and \eqn{\widehat{\tau}}. This correlation is computed from the
\eqn{p}-vectors
\eqn{a} and \eqn{c} and the \eqn{n \times p}
design matrix \eqn{X} using the formula
\eqn{\rho=a^{\top}(X^{\top}X)^{-1}c /(v_{\theta} \, v_{\tau})^{1/2}}, where
\eqn{v_{\theta}
=a^{\top}(X^{\top}X)^{-1} a} and
\eqn{v_{\tau}
=c^{\top}(X^{\top}X)^{-1} c}.

\code{natural}: 1 when the functions \eqn{b} and \eqn{s} are
specified by natural cubic spline interpolation
or 0 if these functions are specified by clamped
cubic spline interpolation

\code{d}: the functions \eqn{b} and \eqn{s} are specified by
cubic splines on the interval \eqn{[-d, d]}

\code{n.ints}: number of equal-length intervals in \eqn{[0, d]}, where
the endpoints of these intervals specify the knots,
belonging to \eqn{[0, d]}, of the cubic spline interpolations
that specify the functions b and s. In the description
of \code{bsvec}, \code{n.ints} is also called \eqn{q}.

\code{bsvec}: the \eqn{(2q-1)}-vector
\deqn{\big(b(h),...,b((q-1)h), s(0),s(h)...,s((q-1)h) \big),}
where \eqn{q}=ceiling(\eqn{d}/0.75) and \eqn{h=d/q}.}
}
\value{
A plot of the graph of the squared scaled
expected length (i.e. squared SEL)
of the CIUUPI as a function of \eqn{|\gamma|}, where
\eqn{\gamma} denotes the unknown parameter
\eqn{\tau \big/ \big(\sigma \, v_{\tau}^{1/2} \big)}.
}
\description{
The input \code{bs.list} determines the functions \eqn{b} and \eqn{s}
that specify the confidence interval that utilizes the uncertain
prior information (CIUUPI), for all possible values of \eqn{\sigma}
and observed response vector.
The scaled expected length of the CIUUPI is an even function of
the unknown parameter
\eqn{\gamma = \tau \big/ \big(\sigma \, v_{\tau}^{1/2} \big)}.
The R function \code{plot_squared_sel} plots the graph of the squared scaled
expected length (i.e. squared SEL)
of the CIUUPI, as a function of \eqn{|\gamma|}.
To provide a stringent
assessment of this squared SEL, we use a grid
\code{seq(0, (d+4), by = 0.01)} of values of
\eqn{\gamma} and Gauss Legendre quadrature
with 10 nodes in the relevant integrals. By contrast,
for the computation
of the CIUUPI, implemented in \code{bs_ciuupi}, we
use Gauss Legendre quadrature
with 5 nodes in the relevant integrals.
}
\examples{
plot_squared_sel(bs.list.example)

}
