
mkShpCmat <- function(shape, knots, ord, intercept,
  mid, lower = -Inf, upper = Inf)
{

  #----- Check the shape

  # List of shapes with parameters
  shplist <- list(
    "pos" = c(d = 0, s = 1), # positive
    "neg" = c(d = 0, s = -1), # negative
    "inc" = c(d = 1, s = 1), # increasing
    "dec" = c(d = 1, s = -1), # decreasing
    "cvx" = c(d = 2, s = 1), # convex
    "ccv" = c(d = 2, s = -1), # concave
    "ushp" = list( # U-shape: decreasing to increasing
      c(d = 1, s = -1, upper = mid),
      c(d = 1, s = 1, lower = mid)),
    "invu" = list( # inverse U: increasing to decreasing
      c(d = 1, s = 1, upper = mid),
      c(d = 1, s = -1, lower = mid)),
    "sshp" = list( # S-shape: increasing and convex to concave
      c(d = 0, s = 1),
      c(d = 2, s = 1, upper = mid),
      c(d = 2, s = -1, lower = mid)),
    "invs" = list( # inverse S-shape: decreasing and concave to convex
      c(d = 0, s = -1),
      c(d = 2, s = -1, upper = mid),
      c(d = 2, s = 1, lower = mid)),
    "rots" = list( # rotated S-shape: decreasing and convex to concave
      c(d = 0, s = -1),
      c(d = 2, s = 1, upper = mid),
      c(d = 2, s = -1, lower = mid)),
    "invrots" = list( # inverse rotated S-shape: increasing and concave to convex
      c(d = 0, s = -1),
      c(d = 2, s = -1, upper = mid),
      c(d = 2, s = 1, lower = mid))
  )

  # Check the shape is in the list
  shape <- match.arg(shape, names(shplist), several.ok = TRUE)

  # Extract the parameter values
  shppars <- lapply(shape, function(shp) {
    prs <- shplist[[shp]]
    if(!is.list(prs)) prs <- list(prs)
    prs
  })

  # Flatten to have a neat list
  shppars <- unlist(shppars, recursive = F)

  # Fill bounds when it is missing
  shppars <- lapply(shppars, function(prs){
    if (! "lower" %in% names(prs)) prs["lower"] <- lower
    if (! "upper" %in% names(prs)) prs["upper"] <- upper
    prs
  })

  # Check difference
  dvec <- sapply(shppars, "[", "d")
  wr <- dvec >= ord
  if (any(wr)) stop("Constrained difference must be lower than the order of the spline")

  #----- Build constraint matrix

  # Extract Cmat for each piece of the constraint
  Cmat <- lapply(shppars, function(prs) mkDmat(d = prs["d"], s = prs["s"],
    lower = prs["lower"], upper = prs["upper"],
    knots = knots, ord = ord, intercept = intercept))

  # Bind together
  Cmat <- do.call(rbind, Cmat)

  # Check Cmat
  chkc <- checkCmat(Cmat)
  Cmat <- Cmat[!chkc$redundant, , drop = F]
  if (length(chkc$equality) > 0) warning("Inconsistencies between shapes")

  #----- Return

  # Add bound attributes
  attr(Cmat, "lb") <- rep(0, NROW(Cmat))
  attr(Cmat, "ub") <- rep(Inf, NROW(Cmat))

  # Return
  Cmat
}
