% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enchunk.R
\name{add_chunk}
\alias{add_chunk}
\title{Transforms a function call into an Rmarkdown chunk}
\usage{
add_chunk(
  report = "",
  fun,
  params,
  chunk_title = NULL,
  title_level = 2,
  echo = FALSE,
  message = FALSE,
  warning = FALSE,
  fig_width = NULL,
  fig_height = NULL,
  guess_title = TRUE
)
}
\arguments{
\item{report}{Character string containing all the R Markdown chunks previously added. Default is '', an empty report.}

\item{fun}{Function to call.}

\item{params}{List of parameters to be passed to fun.}

\item{chunk_title}{Title of the Rmarkdown chunk. If NULL, chronicle will try to parse a generic title based on the function and parameters passed using make_title()}

\item{title_level}{Level of the section title of this plot (ie, number of # on Rmarkdown syntax.)}

\item{echo}{Whether to display the source code in the output document. Default is FALSE.}

\item{message}{Whether to preserve messages on rendering. Default is FALSE.}

\item{warning}{Whether to preserve warnings on rendering. Default is FALSE.}

\item{fig_width}{Width of the plot (in inches).}

\item{fig_height}{Height of the plot (in inches).}

\item{guess_title}{If TRUE, tries to generate a generic title for chronicle::make_* family of functions (eg 'Sepal.Length vs Sepal.Width by Species' for make_scatter)}
}
\value{
An rmarkdown chunk as a character string.
}
\description{
Transforms a function call into an Rmarkdown chunk
}
\examples{
library(chronicle)
html_chunk <- add_chunk(fun = chronicle::make_barplot,
                        params = list(dt = 'iris',
                                      value = 'Sepal.Width',
                                      bars = 'Species'))
cat(html_chunk)
}
