% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_gcms.R
\name{compare_gcms}
\alias{compare_gcms}
\title{Compare General Circulation Models (GCMs)}
\usage{
compare_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  scale = TRUE,
  k = 3,
  clustering_method = "closestdist"
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector with the names of the variables to compare, or 'all' to include all available variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted. Defines the study area for cropping and masking the rasters.}

\item{scale}{Logical. Whether to apply centering and scaling to the data. Default is \code{TRUE}.}

\item{k}{Numeric. The number of clusters to use for k-means clustering.}

\item{clustering_method}{Character. The clustering method to use. One of: "kmeans", "hclust", or "closestdist". Default is "closestdist".}
}
\value{
A list with two items: \code{suggested_gcms} (the names of the GCMs suggested for further analysis) and \code{statistics_gcms} (a grid of plots visualizing the clustering results).
}
\description{
This function compares future climate projections from multiple General Circulation Models (GCMs) based on their similarity in terms of variables. The function uses three clustering algorithms — k-means, hierarchical clustering, and closestdist — to group GCMs, and generates visualizations for the resulting clusters.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)[1:5]
study_area <- terra::ext(c(-80, -70, -50, -40)) |>
  terra::vect(crs="+proj=longlat +datum=WGS84 +no_defs")
compare_gcms(s, var_names, study_area, k = 3, clustering_method = "closestdist")

}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
