% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges_weights_matrix.R
\name{edges_weights_matrix}
\alias{edges_weights_matrix}
\title{Create an edges weights matrix}
\usage{
edges_weights_matrix(distances, lower = TRUE, upper = TRUE, diag = TRUE)
}
\arguments{
\item{distances}{a \code{data.frame} with the following three columns: \code{from}
(the first node of the edge), \code{to} (the second node of the edge), and
\code{weight} (the weight of the edge between the two nodes, e.g. a distance).}

\item{lower}{a \code{logical} value. If \code{TRUE} (default), keep values in the lower
triangle of the matrix. Otherwise they will be replaced by \code{NA}.}

\item{upper}{a \code{logical} value. If \code{TRUE} (default), keep values in the upper
triangle of the matrix. Otherwise they will be replaced by \code{NA}.}

\item{diag}{a \code{logical} value. If \code{TRUE} (default), keep values in the
diagonal of the matrix. Otherwise they will be replaced by \code{NA}.}
}
\value{
An edges weights \code{matrix} of dimensions \verb{n x n}, where \code{n} is the
number of nodes (sites).
}
\description{
Creates an edges weights matrix from the output of \code{\link[=distance_euclidean]{distance_euclidean()}}.
}
\examples{
# Import Adour sites ----
path_to_file <- system.file("extdata", "adour_survey_sampling.csv", 
                            package = "chessboard")
adour_sites <- read.csv(path_to_file)

# Select the 15 first sites ----
adour_sites <- adour_sites[1:15, ]

# Create node labels ----
adour_sites <- create_node_labels(adour_sites, 
                                  location = "location", 
                                  transect = "transect", 
                                  quadrat  = "quadrat")

# Convert sites to sf object (POINTS) ----
adour_sites_sf <- sf::st_as_sf(adour_sites, 
                               coords = c("longitude", "latitude"),
                               crs = "epsg:2154")

# Compute distances between pairs of sites along the Adour river ----
adour_dists <- distance_euclidean(adour_sites_sf)

# Create Edges weights matrix ----
edges_weights_matrix(adour_dists)

# Create Edges weights matrix (with options) ----
edges_weights_matrix(adour_dists, lower = FALSE)
edges_weights_matrix(adour_dists, upper = FALSE)
edges_weights_matrix(adour_dists, diag = FALSE)
}
