% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifiers.R
\name{is_logical_vec}
\alias{is_logical_vec}
\title{Check if a Vector is a Valid Logical Vector}
\usage{
is_logical_vec(logical_vec)
}
\arguments{
\item{logical_vec}{A vector to be evaluated.}
}
\value{
\code{TRUE} if \code{logical_vec} is a valid logical vector,
otherwise \code{FALSE}.
}
\description{
This function checks if a given vector is a valid logical vector. A valid
logical vector is one that contains only logical values (\code{TRUE} or
\code{FALSE}), has a length of at least 1, and does not consist entirely of
missing values (\code{NA}).
}
\examples{
# Check if a valid logical vector
is_logical_vec(c(TRUE, FALSE, TRUE)) # Returns TRUE

# Check if an empty vector
is_logical_vec(c()) # Returns FALSE

# Check if a vector with missing values
is_logical_vec(c(TRUE, FALSE, NA)) # Returns TRUE
is_logical_vec(c(NA, NA, NA)) # Returns FALSE

}
