% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_that.R
\name{check_that}
\alias{check_that}
\title{Check that assertions about a dataframe are true/false}
\usage{
check_that(.data, ..., print = TRUE, raise_error = TRUE, encourage = TRUE)
}
\arguments{
\item{.data}{A dataframe to be tested.}

\item{...}{One or more conditions to test on the dataframe. Each condition
should be expressed as a logical expression that evaluates to a
single \code{TRUE} or \code{FALSE} value (e.g., \code{all(x < 3)},
\code{!any(is.na(x))}).}

\item{print}{Logical. If \code{TRUE}, the results of the tests will be
printed.}

\item{raise_error}{Logical. If \code{TRUE}, an error will be thrown if any
test fails. If \code{FALSE}, the evaluation will
continue even if tests fail. Disabling errors can
sometimes be useful for debugging, but should generally be
avoided in finalized checks/tests.}

\item{encourage}{Logical. If \code{TRUE}, encouraging messages will be
displayed for tests that pass.}
}
\value{
(invisibly) the original, unmodified \code{.data} dataframe.
}
\description{
This function allows you to test whether a set of assertions about a
dataframe are true and to print the results of those tests. It is
particularly useful for quality control and data validation.
}
\details{
The \code{check_that()} function is designed to work with both base R's
existing logical functions, as well as several new functions provided in the
checkthat package (see See Also below).

In addition, it also provides a data pronoun, \code{.d}. This is a copy of
the \code{.data} dataframe provided as the first argument and is useful for
testing not only features of specific rows or columns, but of the entire
dataframe, see examples.
}
\examples{
example_data <- data.frame(x = 1:5, y = 6:10)

# Test a dataframe for specific conditions
example_data |>
  check_that(
    all(x > 0),
    !any(y < 5)
  )

# Use .d pronoun to test aspect of entire dataframe
example_data |>
  check_that(
    nrow(.d) == 5,
    "x" \%in\% names(.d)
  )

}
\seealso{
\code{\link{some_of}}, \code{\link{whenever}},
\code{\link{for_case}}
}
