library(checkargs)
context("isNonEmptyStringScalar")

test_that("isNonEmptyStringScalar works for all arguments", {
  expect_identical(isNonEmptyStringScalar(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNonEmptyStringScalar(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNonEmptyStringScalar(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isNonEmptyStringScalar(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(0, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isNonEmptyStringScalar("X", stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isNonEmptyStringScalar(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNonEmptyStringScalar(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
