library(checkargs)
context("isBooleanScalar")

test_that("isBooleanScalar works for all arguments", {
  expect_identical(isBooleanScalar(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanScalar(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanScalar(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanScalar(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isBooleanScalar(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isBooleanScalar(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanScalar(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isBooleanScalar(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(0, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar("X", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanScalar(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
