% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR.R
\name{local.refine.CV.VAR1}
\alias{local.refine.CV.VAR1}
\title{Local refinement for VAR1 change points detection.}
\usage{
local.refine.CV.VAR1(cpt_init, DATA, zeta_set, delta_local)
}
\arguments{
\item{cpt_init}{A \code{integer} vector of initial change points estimation (sorted in strictly increasing order).}

\item{DATA}{A \code{numeric} matrix of observations with with horizontal axis being time, and vertical axis being dimensions.}

\item{zeta_set}{A \code{numeric} vector of candidate tuning parameters for group lasso penalty.}

\item{delta_local}{A strictly \code{integer} scalar of minimum spacing for group lasso.}
}
\value{
A \code{list} with the following structure:
 \item{cpt_hat}{A vector of estimated change point locations (sorted in strictly increasing order)}
 \item{zeta}{A scalar of selected zeta by cross-validation}
}
\description{
Perform local refinement for VAR1 change points detection.
}
\references{
Wang, Yu, Rinaldo and Willett (2019) <arxiv:1909.06359>
}
\author{
Daren Wang & Haotian Xu
}
