% Generated by roxygen2 (4.0.2): do not edit by hand
\name{communitycent}
\alias{communitycent}
\title{Find the community-based node centrality}
\usage{
communitycent(graph, vids = V(graph), type = c("commweight", "commconn"),
  normalise = TRUE)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{type}{A character string naming the community centrality measure. Can be one of "commweight" or "commconn"}

\item{normalise}{Logical, whether to normalise community connectedness for "commconn". Defaults to TRUE. Will be ignored for "commweight".}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
This function returns community-based node centrality measures.
}
\details{
The "commweight" type weights each community that a node belongs to by how similar that community is to each of the other communities to which the node also belongs.
For node \eqn{i}{i} the community centrality is:
\deqn{C_{c}(i)=\sum_{i \in j}^{N}(1 - \frac{1}{m}\sum_{i \in j\cap k}^{m}S(j,k))}{C_c(i)=sum(1 - 1/m*sum(S(j,k), i in j\cap k, m), i in j, N)}
where the main sum is over the N communities to which node \eqn{i}{i} belongs, and \eqn{S(j,k)}{S(j,k)} refers to the similarity between community \eqn{j}{j} and \eqn{k}{k}, calculated as the Jaccard coefficient for the number of shared nodes between each community pair, and this is averaged over the \eqn{m}{m} communities paired with community \eqn{j}{j} and in which node \eqn{i}{i} jointly belongs. \cr
The "commconn" type weights each community that a node belongs to by how many connections the community forms outside of itself relative to how many connections the community has within itself (the inverse of modularity), so that nodes that belong to more highly connecting communitites will receive a higher community centrality score. For node i the community centrality is:
\deqn{C_{c}(i)=\sum_{i \in j}^{N}e_{ij} \frac{\check{e}_{B(j)}}{\check{e}_{W(j)}}}
where \eqn{e_{ij}}{e(ij)} is the number of edges node \eqn{i}{i} has in community \eqn{j}{j}, \eqn{\check{e}_{B(j)}=\frac{e_{B(j)}}{n_{j}\bar{d}}}{e'(B(j))=e(B(j))/n(j)\bar{d}} is the number of edges community \eqn{j}{j} makes outside of itself normalised by the number of nodes in community \eqn{j}{j} multiplied by the average degree in the network, and \eqn{\check{e}_{W(j)}=\frac{e_{W(j)}}{n(n-1)/2}}{e'(W(j))=e(W(j))/(n(n-1)/2)} is the number of edges within community \eqn{j}{j} normalised by the total number possible. \cr
For more detail see 'linkcomm' package and \href{http://www.centiserver.org/?q1=centrality&q2=Community_Centrality}{Community Centrality}
}
\examples{
\dontrun{
g <- random.graph.game(20, 3/10)
communitycent(g)
}
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}

Code obtained from 'linkcomm' package.
}
\references{
Kalinka, Alex T., and Pavel Tomancak. "linkcomm: an R package for the generation, visualization, and analysis of link communities in networks of arbitrary size and type." Bioinformatics 27.14 (2011).
}

