% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnormvar.R
\name{pnormvar}
\alias{pnormvar}
\title{Cumulative distribution function for t distribution}
\usage{
pnormvar(q, sigma2, n)
}
\arguments{
\item{q}{coordinate at which the cdf is to be evaluated (named in accordance with R standards)}

\item{sigma2}{the assumed normal variance}

\item{n}{the sample size (pass this as an extra argument to cdfinv())}
}
\value{
The quantile of the chi-square distribution for n-1 degrees of freedom corresponding to the input value of the sample variance.
}
\description{
Computes the quantile of the chi-square distribution for n-1 degrees of freedom corresponding to the input value of the sample variance.
}
\details{
Do not call pnormvar() directly.
Pass DISTR="normvar" to cdfinv() when computing intervals for the
normal variance.
The parameter name to be passed to cdfinv() is sigma2.
The additional argument n (sample size) is to be passed to cdfinv().
}
\examples{
cdfinv("normvar","sigma2",14.35,lpb=0,n=22) ## returns 8.493787 29.305942
}
\author{
Peter E. Freeman, \email{pfreeman@cmu.edu}
}
