% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skyl.R
\name{skyl}
\alias{skyl}
\title{Sky light model}
\usage{
skyl(rddt, rsdt, rdot, rsot, Es, Ed, tts, skyl = NULL)
}
\arguments{
\item{rddt}{Bi-hemispherical reflectance}

\item{rsdt}{Directional-hemispherical reflectance for
solar incident flux}

\item{rdot}{Hemispherical-directional reflectance in viewing direction}

\item{rsot}{Bi-directional reflectance factor}

\item{Es}{Solar flux}

\item{Ed}{Diffuse flux}

\item{tts}{solar angle}

\item{skyl}{fraction diffuse}
}
\value{
a list with hemispherical and directional reflectance.
rt<-fRTM(rho~prospect5+foursail)
skyl(rt[,"rddt"],rt[,"rsdt"],rt[,"rdot"],rt[,"rsot"],
Es=solar[,1],Ed=solar[,2],tts=45,skyl=NULL)
}
\description{
Simple atmospherical model that builds on recommendations
from Francois et al. (2002).
}
\examples{
data(solar)
}
\references{
Francois, C., Ottle, C., Olioso, A., Prevot, L., Bruguier, N., 
  Ducros, Y.(2002). Conversion of 400-1100 nm vegetation albedo measurements 
  into total shortwave broadband albedo using a canopy radiative transfer model. 
  Agronomie 22, 611-618.
}
