% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active-transportation.R
\name{active_transport2_fun}
\alias{active_transport2_fun}
\title{Daily active transportation (2007-2014)}
\usage{
active_transport2_fun(PAC_7, PAC_7A, PAC_7B_cont, PAC_8, PAC_8A, PAC_8B_cont)
}
\arguments{
\item{PAC_7}{have walked to work or school in the past 3 months?}

\item{PAC_7A}{number of times walked to work/school in the past 3 months.}

\item{PAC_7B_cont}{number of minutes walk to work/school.}

\item{PAC_8}{have biked to work or school in the past 3 months?}

\item{PAC_8A}{number of times biked to work/school in the past 3 months.}

\item{PAC_8B_cont}{number of minutes bike to work/school.}
}
\value{
Continuous variable for active transportation (active_transport)
}
\description{
This function creates a derived variable for daily time spent 
traveling in active ways. This includes walking and biking. This function is 
used for CCHS 2007-2014.
}
\examples{
# Using active_transport2_fun() to determine daily time spent 
# traveling in active ways values across CCHS 2007-2014.

# active_transport2_fun() is specified in variable_details.csv along with the CCHS
# variables and cycles included.

# To transform active_transport across cycles, use rec_with_table() for each
# CCHS cycle and specify active_transport, along with each activity variable.
# Then by using merge_rec_data(), you can combine active_transport across
# cycles

library(cchsflow)
active_transport2007_2008 <- rec_with_table(
  cchs2007_2008_p, c(
    "PAC_7", "PAC_7A", "PAC_7B_cont", "PAC_8", "PAC_8A", "PAC_8B_cont", 
    "active_transport"
  )
)

head(active_transport2007_2008)

active_transport2013_2014 <- rec_with_table(
  cchs2013_2014_p, c(
    "PAC_7", "PAC_7A", "PAC_7B_cont", "PAC_8", "PAC_8A", "PAC_8B_cont", 
    "active_transport"
  )
)

tail(active_transport2013_2014)

combined_active_transport <- suppressWarnings(merge_rec_data(
 active_transport2007_2008, active_transport2013_2014))

head(combined_active_transport)
tail(combined_active_transport)
}
