% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoking.R
\name{SMKG207_fun}
\alias{SMKG207_fun}
\title{Age started to smoke daily - former daily smoker}
\usage{
SMKG207_fun(SMK_030, SMKG040)
}
\arguments{
\item{SMK_030}{smoked daily - lifetime (occasional/former smoker)}

\item{SMKG040}{age started to smoke daily - daily/former daily smoker}
}
\value{
value for continuous age started to smoke daily for former daily 
smokers in the SMKG207_cont variable
}
\description{
This function creates a continuous derived variable
(SMKG207_cont) for age started to smoke daily for former daily smokers.
}
\details{
For CCHS 2015-2018, age started to smoke daily was combined for daily 
and former daily smokers.Previous cycles had separate variables for age 
started to smoke daily. Smoked daily in lifetime is used to define former 
daily smoker.
}
\examples{
 
# Using SMKG207_fun() to derive age started to smoke daily values across 
# CCHS cycles.
# SMKG207_fun() is specified in variable_details.csv along with the 
# CCHS variables and cycles included.

# To transform SMKG207_A across cycles, use rec_with_table() for each
# CCHS cycle and specify SMKG207_A.
# For CCHS 2001-2014, only specify SMKG207_A.
# For CCHS 2015-2018, specify the parameters and SMKG207_A for former daily 
# smoker age.

library(cchsflow)

agecigfd_2009_2010 <- rec_with_table(
  cchs2009_2010_p, "SMKG207_A")

head(agecigfd_2009_2010)

agecigfd_2017_2018 <- rec_with_table(
  cchs2017_2018_p,c(
    "SMK_030","SMKG040","SMKG207_A"
  )
)

tail(agecigfd_2017_2018)

combined_agecigfd <- suppressWarnings(merge_rec_data
(agecigfd_2009_2010,agecigfd_2017_2018))

head(combined_agecigfd)
tail(combined_agecigfd)

}
