% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_fisher.R
\name{calculate_fisher}
\alias{calculate_fisher}
\title{Calculate direct index according to the Fisher hedonic double imputation method}
\usage{
calculate_fisher(
  dataset,
  period_variable,
  dependent_variable,
  continuous_variables,
  categorical_variables,
  reference_period = NULL,
  number_of_observations = FALSE
)
}
\arguments{
\item{dataset}{table with data (does not need to be a selection of relevant variables)}

\item{period_variable}{variable in the table with periods}

\item{dependent_variable}{usually the sale price}

\item{continuous_variables}{vector with quality determining numeric variables (no dummies)}

\item{categorical_variables}{vector with quality determining categorical variables (also dummies)}

\item{reference_period}{period or group of periods that will be set to 100 (numeric/string)}

\item{number_of_observations}{number of observations per period (default = TRUE)}
}
\value{
table with index, imputation averages, number of observations and confidence intervals per period
}
\description{
By the parameters 'dependent_variable', 'continue_variable' and 'categorical_variables' as regression model is compiled.
With the model, a direct series of index figures is estimated by use of hedonic regression.
}
\details{
N.B.: the independent variables must be entered transformed (and ready) in the parameters.
Hence, not: log(floor_area), but transform the variable in advance and then provide log_floor_area.
This does not count for the dependent variable. This should be entered untransformed

Within the data, it is not neccesary to filter the data on relevant variables or complete records.
This is taken care of in the function.
}
\author{
Farley Ishaak
}
