### objects from ind.decomp.R ========================================================
#' @export
print.ind.sens <- function(x, ...){

  cat("\nResults:\n\n")

  cat("OTRs % Recommended:", x$p.opt, "%\n\n")

  out <- matrix(NA, 4, 3)
  colnames(out) <- c("estimate", "95% CI Lower", "95% CI Upper")
  rownames(out) <- c("Initial Disparity", "Disparity Remaining (ICDE)", "Disparity Remaining (IIE)", "Disparity Reduction (IIE)")
  out[,"estimate"] <- c(x$estimated_tau[[1]], x$estimated_zeta_ICDE, x$estimated_zeta_IIE, x$estimated_delta_IIE)
  out[,"95% CI Lower"] <- out[,"estimate"] - 1.96*c(x$SE_tau, x$SE_zeta_ICDE, x$SE_zeta_IIE, x$SE_delta_IIE)
  out[,"95% CI Upper"] <- out[,"estimate"] + 1.96*c(x$SE_tau, x$SE_zeta_ICDE, x$SE_zeta_IIE, x$SE_delta_IIE)

  print(out)
  cat("\n")

  invisible(x)

}

### objects from ind.decomp.R ========================================================
#' @export
print.ind.decomp <- function(x, ...){

  cat("\nResults:\n\n")

  cat("OTRs % Recommended:", x$p.opt[[1]], "%\n\n")

  out <- matrix(NA, 4, 3)
  colnames(out) <- c("estimate", "95% CI Lower", "95% CI Upper")
  rownames(out) <- c("Initial Disparity", "Disparity Remaining (ICDE)", "Disparity Remaining (IIE)", "Disparity Reduction (IIE)")
  out[,"estimate"] <- c(x$estimated_tau[[1]], x$estimated_zeta_ICDE, x$reg_zeta_IIE, x$reg_delta_IIE)
  out[,"95% CI Lower"] <- out[,"estimate"] - 1.96*c(x$SE_tau, x$SE_zeta_ICDE, x$SE_regzeta_IIE, x$SE_regdelta_IIE)
  out[,"95% CI Upper"] <- out[,"estimate"] + 1.96*c(x$SE_tau, x$SE_zeta_ICDE, x$SE_regzeta_IIE, x$SE_regdelta_IIE)

  print(out)
  cat("\n")

  invisible(x)

}

### objects from sensitivity.R ========================================================
##' @export
print.sensitivity <- function(x, ...){

  cat("\nDisparity Reduction:\n\n")
  redcolnames <- colnames(x$disparity.remaining)
  redout <- data.frame(x$disparity.remaining)
  colnames(redout) <- redcolnames
  print(redout)
  cat("\nDisparity Remaining:\n\n")
  remcolnames <- colnames(x$disparity.reduction)
  remout <- data.frame(x$disparity.reduction)
  colnames(remout) <- remcolnames
  print(remout)
  cat("\n")

  invisible(x)

}

### for objects from smi.R =====================================================
##' @export
print.smi <- function(x, ...){

  cat("\nResults:\n\n")
  print(x$result)
  cat("\n")

  invisible(x)

}

### for objects from mmi.R =====================================================
##' @export
print.mmi <- function(x, ...){

  cat("\nResults:\n\n")
  print(x$result)
  cat("\n")

  invisible(x)

}

### for objects from pocr.R =====================================================
##' @export
print.pocr <- function(x, ...){

  cat("\nResults:\n\n")
  print(x$result)
  cat("\n")

  invisible(x)

}
