% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{validate_positive}
\alias{validate_positive}
\title{Validate Positive or Non-negative Parameter}
\usage{
validate_positive(param_name, param_value, incl_0 = FALSE, is_vector = FALSE)
}
\arguments{
\item{param_name}{A string representing the name of the parameter. Used in the error message.}

\item{param_value}{The parameter value to validate, either a single numeric or a numeric vector.}

\item{incl_0}{Logical, if \code{TRUE}, allows non-negative values (larger or equal to 0); if \code{FALSE}, requires positive values (larger than 0).}

\item{is_vector}{Logical, if \code{TRUE}, treats \code{param_value} as a vector; otherwise, expects a single numeric value.}
}
\value{
\code{NULL} if validation passes; otherwise, an error is raised.
}
\description{
This function checks whether a parameter value is positive (or non-negative if \code{incl_0} is set to \code{TRUE}).
It can handle both single numeric values and vectors, and it raises an error with an informative
message if the validation fails.
}
