% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{traceplot.cat_gibbs}
\alias{traceplot.cat_gibbs}
\title{Traceplot for Gibbs Sampling Model}
\usage{
\method{traceplot}{cat_gibbs}(object, pars = NULL, inc_warmup = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{cat_gibbs} that contains
Gibbs sampling results. The object must include \code{gibbs_iteration_log},
which holds the iteration logs for all sampled parameters, and \code{warmup} and \code{iter}
which indicate the warmup and total iteration counts, respectively.}

\item{pars}{A character vector specifying the parameter names to plot.
If \code{NULL}, the function will select the first 9 parameters automatically.}

\item{inc_warmup}{A logical value indicating whether to include warmup iterations
in the traceplot. If \code{TRUE}, warmup iterations are included, otherwise they are excluded.
Defaults to \code{FALSE}.}

\item{...}{Additional parameters to pass to other functions.}
}
\value{
A series of traceplots for the selected parameters,
showing their evolution over the Gibbs sampling iterations.
}
\description{
This function generates a traceplot for the Gibbs sampling model, which is
typically used for posterior sampling in a Bayesian context. The traceplot
visualizes the evolution of parameter values across Gibbs sampling iterations.
It helps to diagnose the convergence and mixing of the chains.
}
\details{
The function generates a series of line plots for the selected parameters,
displaying their values over the iterations of the Gibbs sampling process.
If \code{inc_warmup} is set to \code{TRUE}, the traceplot includes the warmup period,
otherwise, it starts after the warmup. The traceplots are arranged in a 3x3 grid,
and no more than 9 parameters can be selected for plotting at once.
}
