% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prints.R
\name{extract_stan_summary}
\alias{extract_stan_summary}
\title{Extract and Format Summary of Stan Model Results}
\usage{
extract_stan_summary(x, digit = 3, with_intercept = TRUE)
}
\arguments{
\item{x}{A model object generated from \code{catalytic} that containing a fitted Stan model.}

\item{digit}{An integer specifying the number of decimal places to which the summary
statistics should be rounded. Default is 3.}

\item{with_intercept}{A logical value indicating whether the intercept should be included
in the summary. If \code{TRUE}, the intercept is labeled and included in the formatted output.
Default is \code{TRUE}.}
}
\value{
A matrix of rounded summary statistics from the Stan model, with row names
representing parameter labels and columns containing summary values.
}
\description{
This function extracts the summary statistics from a fitted Stan model stored within
a \code{x} object, formats the parameter names, and rounds values to a specified number
of decimal places. By default, the function includes an intercept term in the summary if
present.
}
