% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_lmm_tune.R
\name{cross_validation_lmm}
\alias{cross_validation_lmm}
\title{Perform Cross-Validation for Catalytic Linear Mixed Model (LMM) to Select Optimal tau}
\usage{
cross_validation_lmm(cat_init, tau_seq, cross_validation_fold_num = 5)
}
\arguments{
\item{cat_init}{A list containing initialized parameters for the catalytic LMM.}

\item{tau_seq}{A numeric vector of tau values for which to estimate risk.}

\item{cross_validation_fold_num}{An integer indicating the number of folds for cross-validation.}
}
\value{
A numeric vector containing the average risk estimates for each tau value.
}
\description{
This function performs cross-validation for the catalytic linear mixed model (LMM) to
estimate the risk associated with different values of tau. It splits the data into
training and testing sets and computes prediction errors for model evaluation.
}
