% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_glm_tune.R
\name{cross_validation}
\alias{cross_validation}
\title{Perform Cross-Validation for Model Estimation}
\usage{
cross_validation(
  formula,
  cat_init,
  tau_seq,
  discrepancy_method,
  cross_validation_fold_num,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the GLMs. Should at least include response variables.}

\item{cat_init}{A list generated from \code{cat_glm_initialization}.}

\item{tau_seq}{A sequence of tuning parameter values (\code{tau}) over which
cross-validation will be performed. Each value of \code{tau} is used to weight the
synthetic data during model fitting.}

\item{discrepancy_method}{A function used to calculate the discrepancy (error) between
model predictions and actual values.}

\item{cross_validation_fold_num}{The number of folds to use in cross-validation.
The dataset will be randomly split into this number of subsets, and the model will be trained and tested on different combinations of these subsets.}

\item{...}{Other arguments passed to other internal functions.}
}
\value{
A numeric vector of averaged risk estimates, one for each value of \code{tau} in \code{tau_seq}.
}
\description{
This function performs cross-validation for estimating risk over a sequence
of tuning parameters (\code{tau_seq}) by fitting a Generalized Linear Model (GLM) to the data.
It evaluates model performance by splitting the dataset into multiple folds, training
the model on a subset of the data, and testing it on the remaining portion.
}
\details{
\enumerate{
\item \strong{Randomization of the Data}: The data is randomly shuffled into \code{cross_validation_fold_num}
subsets to ensure that the model is evaluated across different splits of the dataset.
\item \strong{Model Training and Prediction}: For each fold, a training set is used to fit
a GLM with varying values of \code{tau} (from \code{tau_seq}), and the model is evaluated on a test set.
The training data consists of both the observed and synthetic data, with synthetic data weighted by \code{tau}.
\item \strong{Risk Estimation}: After fitting the model, the \code{discrepancy_method} is used to calculate the
prediction error for each combination of fold and \code{tau}. These errors are accumulated for each \code{tau}.
\item \strong{Average Risk Estimate}: After completing all folds, the accumulated prediction errors
are averaged over the number of folds to provide a final risk estimate for each value of \code{tau}.
}
}
