% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_lmm.R
\name{cat_lmm}
\alias{cat_lmm}
\title{Catalytic Linear Mixed Model (LMM) Fitting Function with fixed tau}
\usage{
cat_lmm(
  cat_init,
  tau = NULL,
  residual_variance_0 = 1,
  random_effect_variance_0 = 1,
  coefs_0 = NULL,
  optimize_domain = c(0, 30),
  max_iter = 500,
  tol = 1e-08
)
}
\arguments{
\item{cat_init}{A list generated from \code{cat_lmm_initialization}.}

\item{tau}{Optional numeric scalar controlling the weight of the synthetic data in the coefficient estimation, defaults to \code{ncol(cat_init$obs_x) / 4}.}

\item{residual_variance_0}{Initial value for residual variance, default is 1.}

\item{random_effect_variance_0}{Initial value for random effect variance, default is 1.}

\item{coefs_0}{Optional initial coefficient vector, default is \code{NULL} which initializes randomly.}

\item{optimize_domain}{Numeric vector of length 2 defining optimization range for variance parameters, default is \code{c(0, 30)}.}

\item{max_iter}{Integer specifying maximum number of iterations for convergence, default is 500.}

\item{tol}{Tolerance for convergence criterion, default is 1e-08.}
}
\value{
A list containing the values of all the arguments and the following components:
\item{coefficients}{Estimated coefficient vector.}
\item{iteration_log}{Matrix logging variance and coefficient values for each iteration.}
}
\description{
Fits a Catalytic linear mixed model (LMM) for observation and synthetic data with specified variance parameters
and iterative coefficient estimation. This function initializes model parameters,
sorts synthetic data, calculates Eigen-decomposition, and iterative optimizes
variance and coefficient values to convergence, by a single given tau value. (Only consider one random effect variance)
}
\examples{
data(mtcars)
cat_init <- cat_lmm_initialization(
  formula = mpg ~ wt + (1 | cyl), # formula for simple model
  data = mtcars,
  x_cols = c("wt"), # Fixed effects
  y_col = "mpg", # Response variable
  z_cols = c("disp", "hp", "drat", "qsec", "vs", "am", "gear", "carb"), # Random effects
  group_col = "cyl", # Grouping column
  syn_size = 100, # Synthetic data size
  resample_by_group = FALSE, # Resampling option
  resample_only = FALSE, # Resampling method
  na_replace = mean # NA replacement method
)

cat_model <- cat_lmm(
  cat_init = cat_init, # Only accept object generated from cat_lmm_initialization
  tau = 1, # Weight for synthetic data
  residual_variance_0 = 1, # Initial value for residual variance
  random_effect_variance_0 = 1, # Initial value for random effect variance
  coefs_0 = c(1), # Initial coefficient vector
  optimize_domain = c(0, 10), # Optimization range for residual and random effect variance
  max_iter = 2, # Maximum number of iterations for convergence
  tol = 1e-01 # Tolerance for convergence criterion
)
cat_model
}
