% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-centered.R
\name{position_centered}
\alias{position_centered}
\title{Centering positioned elements}
\usage{
position_centered(x)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}
}
\value{
An object of the same type as \code{x}.
}
\description{
Use \code{position_centered()} to position an element by its center instead of its edge.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    position("absolute") \%>\%
    position_right(0) \%>\%
    position_centered()
)

tags$button(
  type = "button",
  .style \%>\%
    position("relative") \%>\%
    background_color(theme_primary()),
  "Mail",
  span(
    .style \%>\%
      position("absolute") \%>\%
      position_top(0) \%>\%
      position_right(0) \%>\%
      position_centered() \%>\%
      rounded_all("pill") \%>\%
      background_color(theme_secondary()),
    "+99"
  )
)

}
\seealso{
Other position utilities: 
\code{\link{position_sticky}()},
\code{\link{position}()}
}
\concept{position utilities}
