% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychsyn_critval.R
\name{psychsyn_critval}
\alias{psychsyn_critval}
\title{Compute the correlations between all possible item pairs and order them by the magnitude of the correlation}
\usage{
psychsyn_critval(x, anto = FALSE)
}
\arguments{
\item{x}{a matrix of item responses.}

\item{anto}{ordered by the largest positive correlation, or, if \code{anto = TRUE}, the largest negative correlation.}
}
\description{
A function intended to help finding adequate critical values for \code{psychsyn} and \code{psychant}.
Takes a matrix of item responses and returns a data frame giving the correlations of all item pairs ordered by the magnitude of the correlation.
}
\examples{
psychsyn_cor <- psychsyn_critval(careless_dataset)
psychsyn_cor <- psychsyn_critval(careless_dataset, anto = TRUE)
}
\seealso{
after determining an adequate critical value, continue with \code{\link{psychsyn}} and/or \code{\link{psychant}}
}
\author{
Francisco Wilhelm \email{franciscowilhelm@gmail.com}
}
