% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor-plots.R
\name{ggellipse}
\alias{ggellipse}
\title{Graphical Assessment of Amplitude and Acrophase}
\usage{
ggellipse(object, level = 0.95, ...)
}
\arguments{
\item{object}{Requires a cosinor model to extract the correct statistics to
generate the plot.}

\item{level}{Confidence level for ellipse}

\item{...}{Additional parameters may be needed for extensibility}
}
\value{
Object of class \code{ggplot} to help identify confidence intervals
}
\description{
This is a ggplot-styled graphical representation of the ellipse
region generated by the cosinor analysis. It requires the same data used by
cosinor model to be fit with the model \link{cosinor}. This includes
the amplitude, acrophase,
}
\examples{
data("twins")
m <- cosinor(rDYX ~ hour, twins, tau = 24)
ggellipse(m)
}
