% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/farms_scope1.R
\name{farms_scope1}
\alias{farms_scope1}
\title{Predict Farm Scope 1 Emissions}
\usage{
farms_scope1(
  sic_code,
  farm_area,
  no_beef_cows,
  no_dairy_cows,
  no_pigs,
  no_sheep,
  annual_revenue,
  annual_fuel_spend
)
}
\arguments{
\item{sic_code}{A 4-digit UK SIC code (numeric).}

\item{farm_area}{Farm area in hectares.}

\item{no_beef_cows}{Number of beef cows.}

\item{no_dairy_cows}{Number of dairy cows.}

\item{no_pigs}{Number of pigs.}

\item{no_sheep}{Number of sheep.}

\item{annual_revenue}{Annual revenue (£)}

\item{annual_fuel_spend}{Annual fuel spend (£)}
}
\value{
A dataframe with predicted emissions (tCO2e)
}
\description{
This function loads a pre-trained emission model to predict scope 1 carbon emissions for a British farm.
The function predicts emissions for the following farm types: "Cereals ex. rice", "Dairy", "Mixed farming", "Sheep and goats", "Cattle & buffaloes", "Poultry", "Animal production", "Support for crop production".
}
\examples{
farms_scope1(
sic_code = 1110,
farm_area = 1113,
no_beef_cows = 25,
no_dairy_cows = 8,
no_pigs = 18,
no_sheep = 29,
annual_revenue = 2986511,
annual_fuel_spend = 209055)
}
