% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{CADBCD_Sim}
\alias{CADBCD_Sim}
\title{Simulation Function of Covariate Adjusted Doubly Biased Coin Design for Binary and Continuous Response}
\usage{
CADBCD_Sim(n, thetaA, thetaB, m0 = 40, pts.cov, v = 2, response, target)
}
\arguments{
\item{n}{a positive integer. The value specifies the total number of participants involved in each round of the simulation.}

\item{thetaA}{a vector of length \code{k+1}. The true coefficient parameter value for treatment A.}

\item{thetaB}{a vector of length \code{k+1}. The true coefficient parameter value for treatment B.}

\item{m0}{a positive integer. The number of first 2m0 patients will be allocated equally for estimation. The default value is 40.}

\item{pts.cov}{a \code{n x k} matrix. The simulated covariate matrix for patients.}

\item{v}{a non-negative integer that controls the randomness of CADBCD design. The default value is 2.}

\item{response}{the type of the response. Options are \code{"Binary"} or \code{"Cont"}.}

\item{target}{the type of optimal allocation target. Options are \code{"Neyman"} or \code{"RSIHR"}.}
}
\value{
A list with the following elements:
\item{method}{The name of the procedure.}
\item{sampleSize}{Total number of patients.}
\item{parameter}{Estimated parameter values.}
\item{assignment}{Treatment assignment vector.}
\item{proportion}{Proportion of patients allocated to treatment A.}
\item{responses}{Simulated response values.}
\item{failureRate}{Proportion of treatment failures (if \code{response = "Binary"}).}
\item{meanResponse}{Mean response value (if \code{response = "Cont"}).}
\item{rejectNull}{Logical. Indicates whether the treatment effect is statistically significant based on a Wald test.}
}
\description{
This function simulates a clinical trial using the Covariate Adjusted Doubly Biased Coin Design (CADBCD) with Binary or Continuous Responses.
}
\examples{
set.seed(123)
results = CADBCD_Sim(n = 400,
                      pts.cov = cbind(rnorm(400), rnorm(400)),
                      thetaA = c(-1, 1, 1),
                      thetaB = c(3, 1, 1),
                      response = "Binary",
                      target = "Neyman")
results

## view the settings
results$method
results$sampleSize

## view the simulation results
results$parameter
results$assignments
results$proportion
results$responses
results$failureRate

}
\concept{CADBCD Design}
