findSurvMedian <- function (surv) {
    #############################################################################################
    # Output estimated median survival times in object generated by function survfit.  The median 
    # survival time refers to the minimum time when the survival probability drops below 0.5.  
    # If the survival curve is above 0.5 throughout, output the minimum time.
    #
    # Input:
    # surv: object produced from summary (survfit())
    #
    # Output:
    # vector of median survival time, one for each group
    #############################################################################################
    findSurvMedianBasic <- function (time, prob) {
        return (time[which (prob<= 0.50)[1]])
    }
    
    surv.group <- levels (surv$strata)
    surv.med <- rep (NA, length (surv.group))
    for (i in 1:length (surv.group)){
        ind <- which (surv$strata==surv.group[i])
        if (length (ind)>0) {
            if (surv$surv[ind[length(ind)]]>0.50) {
                surv.med[i] <- surv$time[ind[length(ind)]]
            }
            else {
                surv.med[i] <- findSurvMedianBasic (surv$time[ind], surv$surv[ind])            
            }             
        }
        else {
            surv.med[i] <- NA
        }
    }
    return (surv.med)
}

