% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpm.R
\name{makeCPMSampler}
\alias{makeCPMSampler}
\title{correlated pseudo-marginal: generates functions that output a big vector}
\usage{
makeCPMSampler(
  paramKernSamp,
  logParamKernEval,
  logPriorEval,
  logLikeApproxEval,
  yData,
  numU,
  numIters,
  rho = 0.99,
  storeEvery = 1,
  nansInLLFatal = TRUE
)
}
\arguments{
\item{paramKernSamp}{function(theta) -> theta proposal}

\item{logParamKernEval}{function(oldTheta, newTheta) -> logDensity.}

\item{logPriorEval}{function(theta) -> logDensity.}

\item{logLikeApproxEval}{function(y, thetaProposal, uProposal) -> logApproxDensity.}

\item{yData}{the observed data}

\item{numU}{integer number of u samples}

\item{numIters}{integer number of MCMC iterations}

\item{rho}{correlation tuning parameter (-1,1)}

\item{storeEvery}{increase this integer if you want to use thinning}

\item{nansInLLFatal}{terminate the entire chain on NaNs, or simply disregard sample}
}
\value{
vector of theta samples
}
\description{
correlated pseudo-marginal: generates functions that output a big vector
}
\examples{

# sim data
realTheta1 <- .2 + .3
realTheta2 <- .2
realParams <- c(realTheta1, realTheta2)
numObs <- 10
realX <- rnorm(numObs, mean = 0, sd = sqrt(realTheta2))
realY <- rnorm(numObs, mean = realX, sd = sqrt(realTheta1 - realTheta2))
# tuning params
numImportanceSamps <- 1000
numMCMCIters <- 1000
randomWalkScale <- 1.5
recordEveryTh <- 1
sampler <- makeCPMSampler(
 paramKernSamp = function(params){
   return(params + rnorm(2)*randomWalkScale)
 },
 logParamKernEval = function(oldTheta, newTheta){
   dnorm(newTheta[1], oldTheta[1], sd = randomWalkScale, log = TRUE)
   + dnorm(newTheta[2], oldTheta[2], sd = randomWalkScale, log = TRUE)
 },
 logPriorEval = function(theta){
   if( (theta[1] > theta[2]) & all(theta > 0)){
     0
   }else{
     -Inf
   }
 },
 logLikeApproxEval = function(y, thetaProposal, uProposal){
   if( (thetaProposal[1] > thetaProposal[2]) & (all(thetaProposal > 0))){
     xSamps <- uProposal*sqrt(thetaProposal[2])
     logCondLikes <- sapply(xSamps,
                           function(xsamp) {
                             sum(dnorm(y,
                                       xsamp,
                                       sqrt(thetaProposal[1] - thetaProposal[2]),
                                       log = TRUE)) })
     m <- max(logCondLikes)
     log(sum(exp(logCondLikes - m))) + m - log(length(y))
   }else{
     -Inf
   }
 },
 realY, numImportanceSamps, numMCMCIters, .99, recordEveryTh
)
res <- sampler(realParams)
}
