% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_doi.R
\name{ZoteroDoi}
\alias{ZoteroDoi}
\title{Use DOI to acquire metadata}
\usage{
ZoteroDoi(doi, meta = list(), silent = TRUE, log = list())
}
\arguments{
\item{doi}{A digital object identifier}

\item{meta}{A list collecting all metadata used to create , Default: list()}

\item{silent}{c2z is noisy, tell it to be quiet, Default: TRUE}

\item{log}{A list for storing log elements, Default: list()}
}
\value{
A Zotero-type matrix (tibble)
}
\description{
Connects with doi.org to create metadata
}
\details{
Please see
\href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Simple use of `ZoteroDoi`
  example <- ZoteroDoi("10.1126/sciadv.abd1705")

  # Print index using `ZoteroIndex`
  if (any(nrow(example$data))) {
  ZoteroIndex(example$data) |>
    dplyr::select(name) |>
    print(width = 80)
  }
}
}
\seealso{
\code{\link[httr]{http_error}}, \code{\link[httr]{GET}},
 \code{\link[httr]{RETRY}}
 \code{\link[rvest]{rename}}, \code{\link[rvest]{html_attr}},
 \code{\link[rvest]{html_text}}, \code{\link[rvest]{reexports}},
 \code{\link[rvest]{html_children}}, \code{\link[rvest]{html_name}}
 \code{\link[dplyr]{bind}}, \code{\link[dplyr]{arrange}}
}
