% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization3.R
\name{intliz3}
\alias{intliz3}
\title{Initialization of 3-parameter Block-Basu Bivariate Pareto (BBBVPA) distribution}
\usage{
intliz3(
  data,
  ini.run = 100,
  tol.ini = 0.001,
  proc = "ML",
  intv.a0 = c(0, 5),
  intv.a1 = c(0, 5),
  intv.a2 = c(0, 5),
  ...
)
}
\arguments{
\item{data}{bivariate observations.}

\item{ini.run}{number of random initializations.}

\item{tol.ini}{convergence tolerance, \code{0.001} (default)..}

\item{proc}{different procedures, \code{"ML"} (default) and \code{"S.EM"}.}

\item{intv.a0}{interval for random initialization of \eqn{\alpha_0}.}

\item{intv.a1}{interval for random initialization of \eqn{\alpha_1}.}

\item{intv.a2}{interval for random initialization of \eqn{\alpha_2}.}

\item{...}{further arguments to pass to \code{estimates3}.}
}
\value{
numeric vector.
}
\description{
Return initial choice parameters of 3-parameter BBBVPA distribution.
}
\examples{
dat <- rbb.bvpa(500, 0, 0, 1.0, 1.0, 2.0, 0.4, 0.5)
intliz3(dat)

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
