% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization.R
\name{intliz}
\alias{intliz}
\title{Initialization of Block-Basu Bivariate Pareto (BBBVPA) distribution}
\usage{
intliz(
  data,
  ini.run = 100,
  tol.ini = 0.001,
  proc = "ML",
  intv.s1 = c(0, 5),
  intv.s2 = c(0, 5),
  intv.a0 = c(0, 5),
  intv.a1 = c(0, 5),
  intv.a2 = c(0, 5),
  ...
)
}
\arguments{
\item{data}{bivariate observations.}

\item{ini.run}{number of random initializations.}

\item{tol.ini}{convergence tolerance, \code{0.001} (default)..}

\item{proc}{different procedures, \code{"ML"} (default) and \code{"S.EM"}.}

\item{intv.s1}{interval for random initialization of \eqn{\sigma_1}.}

\item{intv.s2}{interval for random initialization of \eqn{\sigma_2}.}

\item{intv.a0}{interval for random initialization of \eqn{\alpha_0}.}

\item{intv.a1}{interval for random initialization of \eqn{\alpha_1}.}

\item{intv.a2}{interval for random initialization of \eqn{\alpha_2}.}

\item{...}{further arguments to pass to \code{estimates}.}
}
\value{
numeric vector.
}
\description{
Return initial choice parameters of BBBVPA distribution.
}
\examples{
# see the example of estimation

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
