% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvar-minnesota.R, R/print-bvarmn.R,
%   R/criteria.R, R/member.R
\name{bvar_minnesota}
\alias{bvar_minnesota}
\alias{print.bvarmn}
\alias{print.bvarhm}
\alias{logLik.bvarmn}
\alias{AIC.bvarmn}
\alias{BIC.bvarmn}
\alias{is.bvarmn}
\alias{knit_print.bvarmn}
\alias{knit_print.bvarhm}
\title{Fitting Bayesian VAR(p) of Minnesota Prior}
\usage{
bvar_minnesota(
  y,
  p = 1,
  num_chains = 1,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = set_bvar(),
  scale_variance = 0.05,
  include_mean = TRUE,
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvarmn}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{bvarhm}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{logLik}{bvarmn}(object, ...)

\method{AIC}{bvarmn}(object, ...)

\method{BIC}{bvarmn}(object, ...)

is.bvarmn(x)

\method{knit_print}{bvarmn}(x, ...)

\method{knit_print}{bvarhm}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{VAR lag (Default: 1)}

\item{num_chains}{Number of MCMC chains}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A BVAR model specification by \code{\link[=set_bvar]{set_bvar()}}.}

\item{scale_variance}{Proposal distribution scaling constant to adjust an acceptance rate}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{Number of threads}

\item{x}{Any object}

\item{digits}{digit option to print}

\item{...}{not used}

\item{object}{A \code{bvarmn} object}
}
\value{
\code{bvar_minnesota()} returns an object \code{bvarmn} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Posterior Mean}
\item{fitted.values}{Fitted values}
\item{residuals}{Residuals}
\item{mn_mean}{Posterior mean matrix of Matrix Normal distribution}
\item{mn_prec}{Posterior precision matrix of Matrix Normal distribution}
\item{iw_scale}{Posterior scale matrix of posterior inverse-Wishart distribution}
\item{iw_shape}{Posterior shape of inverse-Wishart distribution (\eqn{alpha_0} - obs + 2). \eqn{\alpha_0}: nrow(Dummy observation) - k}
\item{df}{Numer of Coefficients: mp + 1 or mp}
\item{m}{Dimension of the time series}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{prior_mean}{Prior mean matrix of Matrix Normal distribution: \eqn{A_0}}
\item{prior_precision}{Prior precision matrix of Matrix Normal distribution: \eqn{\Omega_0^{-1}}}
\item{prior_scale}{Prior scale matrix of inverse-Wishart distribution: \eqn{S_0}}
\item{prior_shape}{Prior shape of inverse-Wishart distribution: \eqn{\alpha_0}}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{p}{Lag of VAR}
\item{totobs}{Total number of the observation}
\item{type}{include constant term (\code{const}) or not (\code{none})}
\item{y}{Raw input (\code{matrix})}
\item{call}{Matched call}
\item{process}{Process string in the \code{bayes_spec}: \code{BVAR_Minnesota}}
\item{spec}{Model specification (\code{bvharspec})}
}
It is also \code{normaliw} and \code{bvharmod} class.
}
\description{
This function fits BVAR(p) with Minnesota prior.
}
\details{
Minnesota prior gives prior to parameters \eqn{A} (VAR matrices) and \eqn{\Sigma_e} (residual covariance).

\deqn{A \mid \Sigma_e \sim MN(A_0, \Omega_0, \Sigma_e)}
\deqn{\Sigma_e \sim IW(S_0, \alpha_0)}
(MN: \href{https://en.wikipedia.org/wiki/Matrix_normal_distribution}{matrix normal}, IW: \href{https://en.wikipedia.org/wiki/Inverse-Wishart_distribution}{inverse-wishart})
}
\examples{
# Perform the function using etf_vix dataset
\dontrun{
fit <- bvar_minnesota(y = etf_vix[, 1:3], p = 2)
class(fit)
}

# Extract coef, fitted values, and residuals
\dontrun{
coef(fit)
head(residuals(fit))
head(fitted(fit))
}
}
\references{
Bańbura, M., Giannone, D., & Reichlin, L. (2010). \emph{Large Bayesian vector auto regressions}. Journal of Applied Econometrics, 25(1).

Giannone, D., Lenza, M., & Primiceri, G. E. (2015). \emph{Prior Selection for Vector Autoregressions}. Review of Economics and Statistics, 97(2).

Litterman, R. B. (1986). \emph{Forecasting with Bayesian Vector Autoregressions: Five Years of Experience}. Journal of Business & Economic Statistics, 4(1), 25.

KADIYALA, K.R. and KARLSSON, S. (1997), \emph{NUMERICAL METHODS FOR ESTIMATION AND INFERENCE IN BAYESIAN VAR-MODELS}. J. Appl. Econ., 12: 99-132.

Karlsson, S. (2013). \emph{Chapter 15 Forecasting with Bayesian Vector Autoregression}. Handbook of Economic Forecasting, 2, 791-897.

Sims, C. A., & Zha, T. (1998). \emph{Bayesian Methods for Dynamic Multivariate Models}. International Economic Review, 39(4), 949-968.
}
\seealso{
\itemize{
\item \code{\link[=set_bvar]{set_bvar()}} to specify the hyperparameters of Minnesota prior.
\item \code{\link[=summary.normaliw]{summary.normaliw()}} to summarize BVAR model
}
}
