% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_install_server_deps}
\alias{do_install_server_deps}
\title{Install server dependencies on a droplet}
\usage{
do_install_server_deps(droplet, keyfile = do_keyfile())
}
\arguments{
\item{droplet}{The DigitalOcean droplet that you want to provision
(see \code{\link[analogsea:droplet]{analogsea::droplet()}}). If empty, a new DigitalOcean server will be created.}

\item{keyfile}{Path to private key for authentication. By default, uses the
key for "digitalocean.com" from \code{\link[ssh:ssh_credentials]{ssh::ssh_key_info()}}.}
}
\value{
Invisibly returns NULL. Called for side effects.
}
\description{
Installs R and common dependencies needed for running _server.yml applications.
This is called automatically by \code{\link[=do_provision]{do_provision()}} but can be called separately
if needed.
}
\examples{
\dontrun{
  # Reinstall or update server dependencies on an existing droplet
  droplet <- analogsea::droplet(123456)
  do_install_server_deps(droplet)
}
}
