% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12_shortPutGraph.R
\name{shortPut}
\alias{shortPut}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven (BE) point at expiration for European Short Put and draws its graph in the Plots tab.}
\usage{
shortPut(
  ST,
  X,
  P,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Short Put ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{P}{Put Premium received on sold Put.}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Short Put.
}
\description{
Selling a put is a simple, short-term income strategy.  When you sell a put, you have sold you receive a put premium or put price and obligation to buy from put buyer. Trader or investors outlook is bullish and the expectation is that price will rise and will never be exercised (Kakushadze & Serur, 2018).
}
\details{
This method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and also the Breakeven (BE) point for a Short Put and draws its graph in the Plots tab.
}
\examples{
shortPut(17,18,1.44)
shortPut(50,55,8,hl=0.7,hu=1.2)
shortPut(1000,1000,10,hl=0.97,hu=1.02)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
