% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_coveredShortStrangle.R
\name{coveredShortStrangle}
\alias{coveredShortStrangle}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven (BE)point at expiration for Covered Short Strangle and draws its graph in the Plots tab.}
\usage{
coveredShortStrangle(
  ST,
  XH,
  XL,
  CXH,
  PXL,
  S0,
  hl = 0,
  hu = 1.6,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Covered Short Strangle ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{XH}{Higher Strike Price or eXercise price.}

\item{XL}{Lower Strike Price or eXercise price.}

\item{CXH}{Call Premium received on shorted higher Strike call.}

\item{PXL}{Put Premium received on shorted lower Strike Put.}

\item{S0}{Initial Stock Price}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Sub title of the Graph.}
}
\value{
returns a profit and loss graph of Covered Short Strangle.
}
\description{
This strategy amounts to augmenting a covered call by writing an OTM put option with a higher strike price (XL) and the same time to maturity (TTM) as the sold call option (whose strike price is XH) and thereby increasing the income. Breakeven (BE) point of Covered Short Strangle varies depending on the relationship between the stock price, premiums received, and the strikes (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Covered Short Strangle and draws its graph in the Plots tab.
}
\examples{
coveredShortStrangle(17,21,12,1.44,3.56,15.84)
coveredShortStrangle(50,55,45,4,11,48,hl=0.7,hu=1.2)
coveredShortStrangle(1000,1010,990,10,24,990,hl=0.97,hu=1.02)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
