% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curves.R
\name{plot_curves.bgmfit}
\alias{plot_curves.bgmfit}
\alias{plot_curves}
\title{Plot Growth Curves}
\usage{
\method{plot_curves}{bgmfit}(
  model,
  opt = "dv",
  apv = FALSE,
  bands = NULL,
  conf = 0.95,
  resp = NULL,
  dpar = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  newdata = NULL,
  summary = FALSE,
  digits = 2,
  re_formula = NULL,
  numeric_cov_at = NULL,
  aux_variables = NULL,
  levels_id = NULL,
  avg_reffects = NULL,
  ipts = 10,
  deriv_model = TRUE,
  xrange = NULL,
  xrange_search = NULL,
  takeoff = FALSE,
  trough = FALSE,
  acgv = FALSE,
  acgv_velocity = 0.1,
  seed = 123,
  estimation_method = "fitted",
  allow_new_levels = FALSE,
  sample_new_levels = "uncertainty",
  incl_autocor = TRUE,
  robust = FALSE,
  transform = NULL,
  future = FALSE,
  future_session = "multisession",
  cores = NULL,
  trim = 0,
  layout = "single",
  linecolor = NULL,
  linecolor1 = NULL,
  linecolor2 = NULL,
  label.x = NULL,
  label.y = NULL,
  legendpos = NULL,
  linetype.apv = NULL,
  linewidth.main = NULL,
  linewidth.apv = NULL,
  linetype.groupby = NA,
  color.groupby = NA,
  band.alpha = NULL,
  show_age_takeoff = TRUE,
  show_age_peak = TRUE,
  show_age_cessation = TRUE,
  show_vel_takeoff = FALSE,
  show_vel_peak = FALSE,
  show_vel_cessation = FALSE,
  returndata = FALSE,
  returndata_add_parms = FALSE,
  parms_eval = FALSE,
  idata_method = NULL,
  parms_method = "getPeak",
  verbose = FALSE,
  fullframe = NULL,
  dummy_to_factor = NULL,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  funlist = NULL,
  envir = NULL,
  ...
)

plot_curves(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{opt}{A character string containing one or more of the following
plotting options:
\itemize{
\item 'd': Population average distance curve
\item 'v': Population average velocity curve
\item 'D': Individual-specific distance curves
\item 'V': Individual-specific velocity curves
\item 'u': Unadjusted individual-specific distance curves
\item 'a': Adjusted individual-specific distance curves (adjusted for
random effects)
}

Note that 'd' and 'D' cannot be specified simultaneously, nor can 'v' and
'V'. Other combinations are allowed, e.g., 'dvau', 'Dvau', 'dVau', etc.}

\item{apv}{A logical value (default \code{FALSE}) indicating whether to
calculate and plot the age at peak velocity (APGV) when \code{opt} includes
'v' or 'V'.}

\item{bands}{A character string containing one or more of the following
options, or \code{NULL} (default), indicating if CI bands should be plotted
around the curves:
\itemize{
\item 'd': Band around the distance curve
\item 'v': Band around the velocity curve
\item 'p': Band around the vertical line denoting the APGV parameter
}

The \code{'dvp'} option will include CI bands for distance and velocity
curves, and the APGV.}

\item{conf}{A numeric value (default \code{0.95}) specifying the confidence
interval (CI) level for the bands. See \code{\link[=growthparameters]{growthparameters()}} for
more details.}

\item{resp}{A character string (default \code{NULL}) to specify the response
variable when processing posterior draws for \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{ndraws}{A positive integer indicating the number of posterior draws to
use in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer specifying the specific posterior draw(s) to use
in estimation (default \code{NULL}).}

\item{newdata}{An optional data frame for estimation. If \code{NULL}
(default), \code{newdata} is retrieved from the \code{model}.}

\item{summary}{A logical value indicating whether only the estimate should be
computed (\code{TRUE}), or whether the estimate along with SE and CI should
be returned (\code{FALSE}, default). Setting \code{summary} to \code{FALSE}
will increase computation time. Note that \code{summary = FALSE} is
required to obtain correct estimates when \code{re_formula = NULL}.}

\item{digits}{An integer (default \code{2}) to set the decimal places for
rounding the results using the \code{\link[base:Round]{base::round()}} function.}

\item{re_formula}{Option to indicate whether or not to include
individual/group-level effects in the estimation. When \code{NA} (default),
individual-level effects are excluded, and population average growth
parameters are computed. When \code{NULL}, individual-level effects are
included in the computation, and the resulting growth parameters are
individual-specific. In both cases (\code{NA} or \code{NULL}), continuous
and factor covariates are appropriately included in the estimation.
Continuous covariates are set to their means by default (see
\code{numeric_cov_at} for details), while factor covariates remain
unaltered, allowing for the estimation of covariate-specific population
average and individual-specific growth parameters.}

\item{numeric_cov_at}{An optional (named list) argument to specify the value
of continuous covariate(s). The default \code{NULL} option sets the
continuous covariate(s) to their mean. Alternatively, a named list can be
supplied to manually set these values. For example, \code{numeric_cov_at =
  list(xx = 2)} will set the continuous covariate variable 'xx' to 2. The
argument \code{numeric_cov_at} is ignored when no continuous covariates are
included in the model.}

\item{aux_variables}{An optional argument to specify variables passed to the
\code{ipts} argument, useful when fitting location-scale or measurement
error models.}

\item{levels_id}{An optional argument to specify the \code{ids} for the
hierarchical model (default \code{NULL}). It is used only when the model is
applied to data with three or more levels of hierarchy. For a two-level
model, \code{levels_id} is automatically inferred from the model fit. For
models with three or more levels, \code{levels_id} is inferred from the
model fit under the assumption that hierarchy is specified from the lowest
to the uppermost level, i.e., \code{id} followed by \code{study}, where
\code{id} is nested within \code{study}. However, it is not guaranteed that
\code{levels_id} is sorted correctly, so it is better to set it manually
when fitting a model with three or more levels of hierarchy.}

\item{avg_reffects}{An optional argument (default \code{NULL}) to calculate
(marginal/average) curves and growth parameters, such as APGV and PGV. If
specified, it must be a named list indicating the \code{over} (typically a
level 1 predictor, such as age), \code{feby} (fixed effects, typically a
factor variable), and \code{reby} (typically \code{NULL}, indicating that
parameters are integrated over the random effects). For example,
\code{avg_reffects = list(feby = 'study', reby = NULL, over = 'age')}.}

\item{ipts}{An integer to set the length of the predictor variable for
generating a smooth velocity curve. If \code{NULL}, the original values are
returned. If an integer (e.g., \code{ipts = 10}, default), the predictor is
interpolated. Note that these interpolations do not alter the range of the
predictor when calculating population averages and/or individual-specific
growth curves.}

\item{deriv_model}{A logical value specifying whether to estimate the
velocity curve from the derivative function or by differentiating the
distance curve. Set \code{deriv_model = TRUE} for functions that require
the velocity curve, such as \code{growthparameters()} and
\code{plot_curves()}. Set it to \code{NULL} for functions that use the
distance curve (i.e., fitted values), such as \code{loo_validation()} and
\code{plot_ppc()}.}

\item{xrange}{An integer to set the predictor range (e.g., age) when
executing the interpolation via \code{ipts}. By default, \code{NULL} sets
the individual-specific predictor range. Setting \code{xrange = 1} applies
the same range for individuals within the same higher grouping variable
(e.g., study). Setting \code{xrange = 2} applies an identical range across
the entire sample. Alternatively, a numeric vector (e.g., \code{xrange =
  c(6, 20)}) can be provided to set the range within the specified values.}

\item{xrange_search}{A vector of length two or a character string
\code{'range'} to set the range of the predictor variable (\code{x}) within
which growth parameters are searched. This is useful when there is more
than one peak and the user wants to summarize the peak within a specified
range of the \code{x} variable. The default value is \code{xrange_search =
  NULL}.}

\item{takeoff}{A logical value (default \code{FALSE}) indicating whether to
calculate the age at takeoff velocity (ATGV) and the takeoff growth
velocity (TGV) parameters.}

\item{trough}{A logical value (default \code{FALSE}) indicating whether to
calculate the age at cessation of growth velocity (ACGV) and the cessation
of growth velocity (CGV) parameters.}

\item{acgv}{A logical value (default \code{FALSE}) indicating whether to
calculate the age at cessation of growth velocity from the velocity curve.
If \code{TRUE}, the age at cessation of growth velocity (ACGV) and the
cessation growth velocity (CGV) are calculated based on the percentage of
the peak growth velocity, as defined by the \code{acgv_velocity} argument
(see below). The \code{acgv_velocity} is typically set at 10 percent of the
peak growth velocity. ACGV and CGV are calculated along with the
uncertainty (SE and CI) around the ACGV and CGV parameters.}

\item{acgv_velocity}{The percentage of the peak growth velocity to use when
estimating \code{acgv}. The default value is \code{0.10}, i.e., 10 percent
of the peak growth velocity.}

\item{seed}{An integer (default \code{123}) that is passed to the estimation
method to ensure reproducibility.}

\item{estimation_method}{A character string specifying the estimation method
when calculating the velocity from the posterior draws. The \code{'fitted'}
method internally calls \code{\link[=fitted_draws]{fitted_draws()}}, while the
\code{'predict'} method calls \code{\link[=predict_draws]{predict_draws()}}. See
\code{\link[brms:fitted.brmsfit]{brms::fitted.brmsfit()}} and \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for details.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), each posterior sample for a
new level is drawn from the posterior draws of a randomly chosen existing
level. Each posterior sample for a new level may be drawn from a different
existing level such that the resulting set of new posterior draws
represents the variation across existing levels. If \code{"gaussian"},
sample new levels from the (multivariate) normal distribution implied by the
group-level standard deviations and correlations. This options may be useful
for conducting Bayesian power analysis or predicting new levels in
situations where relatively few levels where observed in the old_data. If
\code{"old_levels"}, directly sample new levels from the existing levels,
where a new level is assigned all of the posterior draws of the same
(randomly chosen) existing level.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{robust}{A logical value to specify the summary options. If \code{FALSE}
(default), the mean is used as the measure of central tendency and the
standard deviation as the measure of variability. If \code{TRUE}, the
median and median absolute deviation (MAD) are applied instead. Ignored if
\code{summary} is \code{FALSE}.}

\item{transform}{A function applied to individual draws from the posterior
distribution before computing summaries. The argument \code{transform} is
based on the \code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} function. This should not be
confused with \code{transform} from \code{\link[brms:posterior_predict.brmsfit]{brms::posterior_predict()}}, which is
now deprecated.}

\item{future}{A logical value (default \code{FALSE}) to specify whether or
not to perform parallel computations. If set to \code{TRUE}, the
\code{\link[future.apply:future_lapply]{future.apply::future_sapply()}} function is used to summarize the posterior
draws in parallel.}

\item{future_session}{A character string specifying the session type when
\code{future = TRUE}. The \code{'multisession'} (default) option sets the
multisession environment, while the \code{'multicore'} option sets up a
multicore session. Note that \code{'multicore'} is not supported on Windows
systems. For more details, see \code{\link[future.apply:future_lapply]{future.apply::future_sapply()}}.}

\item{cores}{The number of cores to be used for parallel computations if
\code{future = TRUE}. On non-Windows systems, this argument can be set
globally via the \code{mc.cores} option. By default, \code{NULL}, the
number of cores is automatically determined using
\code{\link[future:re-exports]{future::availableCores()}}, and it will use the maximum number of cores
available minus one (i.e., \code{future::availableCores() - 1}).}

\item{trim}{A numeric value (default \code{0}) indicating the number of long
line segments to be excluded from the plot when the option 'u' or 'a' is
selected. See \link[sitar:plot.sitar]{sitar::plot.sitar} for further details.}

\item{layout}{A character string defining the plot layout. The default
\code{'single'} layout overlays distance and velocity curves on a single
plot when \code{opt} includes combinations like \code{'dv'}, \code{'Dv'},
\code{'dV'}, or \code{'DV'}. The alternative layout option \code{'facet'}
uses \code{facet_wrap} from \pkg{ggplot2} to map and draw plots when
\code{opt} includes two or more letters.}

\item{linecolor}{The color of the lines when the layout is \code{'facet'}.
The default is \code{NULL}, which sets the line color to \code{'grey50'}.}

\item{linecolor1}{The color of the first line when the layout is
\code{'single'}. For example, in \code{opt = 'dv'}, the distance line is
controlled by \code{linecolor1}. The default \code{NULL} sets
\code{linecolor1} to \code{'orange2'}.}

\item{linecolor2}{The color of the second line when the layout is
\code{'single'}. For example, in \code{opt = 'dv'}, the velocity line is
controlled by \code{linecolor2}. The default \code{NULL} sets
\code{linecolor2} to \code{'green4'}.}

\item{label.x}{An optional character string to label the x-axis. If
\code{NULL} (default), the x-axis label will be taken from the predictor
(e.g., age).}

\item{label.y}{An optional character string to label the y-axis. If
\code{NULL} (default), the y-axis label will be taken from the plot type
(e.g., distance, velocity). When \code{layout = 'facet'}, the label is
removed, and the same label is used as the title.}

\item{legendpos}{A character string to specify the position of the legend. If
\code{NULL} (default), the legend position is set to 'bottom' for distance
and velocity curves in the \code{'single'} layout. For individual-specific
curves, the legend position is set to \code{'none'} to suppress the legend.}

\item{linetype.apv}{A character string to specify the type of the vertical
line marking the APGV. Default \code{NULL} sets the linetype to
\code{dotted}.}

\item{linewidth.main}{A numeric value to specify the line width for distance
and velocity curves. The default \code{NULL} sets the width to 0.35.}

\item{linewidth.apv}{A numeric value to specify the width of the vertical
line marking the APGV. The default \code{NULL} sets the width to 0.25.}

\item{linetype.groupby}{A character string specifying the line type for
distance and velocity curves when drawing plots for a model with factor
covariates or individual-specific curves. The default is \code{NA}, which
sets the line type to 'solid' and suppresses legends.}

\item{color.groupby}{A character string specifying the line color for
distance and velocity curves when drawing plots for a model with factor
covariates or individual-specific curves. The default is \code{NA}, which
suppresses legends.}

\item{band.alpha}{A numeric value to specify the transparency of the CI bands
around the curves. The default \code{NULL} sets the transparency to 0.4.}

\item{show_age_takeoff}{A logical value (default \code{TRUE}) to indicate
whether to display the ATGV line(s) on the plot.}

\item{show_age_peak}{A logical value (default \code{TRUE}) to indicate
whether to display the APGV line(s) on the plot.}

\item{show_age_cessation}{A logical value (default \code{TRUE}) to indicate
whether to display the ACGV line(s) on the plot.}

\item{show_vel_takeoff}{A logical value (default \code{FALSE}) to indicate
whether to display the TGV line(s) on the plot.}

\item{show_vel_peak}{A logical value (default \code{FALSE}) to indicate
whether to display the PGV line(s) on the plot.}

\item{show_vel_cessation}{A logical value (default \code{FALSE}) to indicate
whether to display the CGV line(s) on the plot.}

\item{returndata}{A logical value (default \code{FALSE}) to indicate whether
to plot the data or return it as a \code{data.frame}.}

\item{returndata_add_parms}{A logical value (default \code{FALSE}) to specify
whether to add growth parameters to the returned \code{data.frame}. Ignored
when \code{returndata = FALSE}. Growth parameters are added when the
\code{opt} argument includes 'v' or 'V' and \code{apv = TRUE}.}

\item{parms_eval}{A logical value to specify whether or not to compute growth
parameters on the fly. This is for internal use only and is mainly needed
for compatibility across internal functions.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of interpolation points is set by the \code{ipts} argument.
Available options for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}).
\itemize{
\item \emph{Method 1} (\code{'m1'}) is adapted from the \pkg{iapvbs} package
and is documented
\href{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}{here}.
\item \emph{Method 2} (\code{'m2'}) is based on the \pkg{JMbayes} package
and is documented
\href{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}{here}.
The \code{'m1'} method works by internally constructing the data frame
based on the model configuration, while the \code{'m2'} method uses the
exact data frame from the model fit, accessible via \code{fit$data}. If
\code{idata_method = NULL} (default), method \code{'m2'} is automatically
selected. Note that method \code{'m1'} may fail in certain cases,
especially when the model includes covariates (particularly in
\code{univariate_by} models). In such cases, it is recommended to use
method \code{'m2'}.
}}

\item{parms_method}{A character string specifying the method used when
evaluating \code{parms_eval}. The default method is \code{getPeak}, which
uses the \code{\link[sitar:getPeakTrough]{sitar::getPeak()}} function from the \code{sitar} package.
Alternatively, \code{findpeaks} uses the \code{findpeaks} function from the
\code{pracma} package. This parameter is for internal use and ensures
compatibility across internal functions.}

\item{verbose}{A logical argument (default \code{FALSE}) to specify whether
to print information collected during the setup of the object(s).}

\item{fullframe}{A logical value indicating whether to return a
\code{fullframe} object in which \code{newdata} is bound to the summary
estimates. Note that \code{fullframe} cannot be used with \code{summary =
  FALSE}, and it is only applicable when \code{idata_method = 'm2'}. A
typical use case is when fitting a \code{univariate_by} model. This option
is mainly for internal use.}

\item{dummy_to_factor}{A named list (default \code{NULL}) to convert dummy
variables into a factor variable. The list must include the following
elements:
\itemize{
\item \code{factor.dummy}: A character vector of dummy variables to be
converted to factors.
\item \code{factor.name}: The name for the newly created factor variable
(default is \code{'factor.var'} if \code{NULL}).
\item \code{factor.level}: A vector specifying the factor levels.
If \code{NULL}, levels are taken from \code{factor.dummy}.
If \code{factor.level} is provided, its length must match
\code{factor.dummy}.
}}

\item{expose_function}{A logical argument (default \code{FALSE}) to indicate
whether Stan functions should be exposed. If \code{TRUE}, any Stan
functions exposed during the model fit using \code{expose_function = TRUE}
in the \code{\link[=bsitar]{bsitar()}} function are saved and can be used in post-processing. By
default, \code{expose_function = FALSE} in post-processing functions,
except in \code{\link[=optimize_model]{optimize_model()}} where it is set to \code{NULL}. If
\code{NULL}, the setting is inherited from the original model fit. It must
be set to \code{TRUE} when adding \code{fit criteria} or \code{bayes_R2}
during model optimization.}

\item{usesavedfuns}{A logical value (default \code{NULL}) indicating whether
to use already exposed and saved Stan functions. This is typically set
automatically based on the \code{expose_functions} argument from the
\code{\link[=bsitar]{bsitar()}} call. Manual specification of \code{usesavedfuns} is rarely
needed and is intended for internal testing, as improper use can lead to
unreliable estimates.}

\item{clearenvfuns}{A logical value indicating whether to clear the exposed
Stan functions from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL}, \code{clearenvfuns} is set based on the value of
\code{usesavedfuns}: \code{TRUE} if \code{usesavedfuns = TRUE}, or
\code{FALSE} if \code{usesavedfuns = FALSE}.}

\item{funlist}{A list (default \code{NULL}) specifying function names. This
is rarely needed, as required functions are typically retrieved
automatically. A use case for \code{funlist} is when \code{sigma_formula},
\code{sigma_formula_gr}, or \code{sigma_formula_gr_str} use an external
function (e.g., \code{poly(age)}). The \code{funlist} should include
function names defined in the \code{globalenv()}. For functions needing
both distance and velocity curves (e.g., \code{plot_curves(..., opt =
  'dv')}), \code{funlist} must include two functions: one for the distance
curve and one for the velocity curve.}

\item{envir}{The environment used for function evaluation. The default is
\code{NULL}, which sets the environment to \code{parent.frame()}. Since
most post-processing functions rely on \pkg{brms}, it is recommended to set
\code{envir = globalenv()} or \code{envir = .GlobalEnv}, especially for
derivatives like velocity curves.}

\item{...}{Additional arguments passed to the \code{brms::fitted.brmsfit()}
and \code{brms::predict()} functions.}
}
\value{
A plot object (default) or a \code{data.frame} when \code{returndata
  = TRUE}.
}
\description{
The \strong{plot_curves()} function visualizes six different
types of growth curves using the \pkg{ggplot2} package. Additionally, it
allows users to create customized plots from the data returned as a
\code{data.frame}. For an alternative approach, the \code{\link[=marginal_draws]{marginal_draws()}}
function can be used, which not only estimates adjusted curves but also
enables comparison across groups using the \code{hypotheses} argument.
}
\details{
The \strong{plot_curves()} function is a generic tool for
visualizing the following six curves:
\itemize{
\item Population average distance curve
\item Population average velocity curve
\item Individual-specific distance curves
\item Individual-specific velocity curves
\item Unadjusted individual growth curves (i.e., observed growth curves)
\item Adjusted individual growth curves (adjusted for the model-estimated
random effects)
}

Internally, \strong{plot_curves()} calls the \code{\link[=growthparameters]{growthparameters()}} function
to estimate and summarize the distance and velocity curves, as well as to
compute growth parameters such as the age at peak growth velocity (APGV).
The function also calls \code{\link[=fitted_draws]{fitted_draws()}} or \code{\link[=predict_draws]{predict_draws()}} to make
inferences based on posterior draws. As a result, \strong{plot_curves()}
can plot either fitted or predicted curves. For more details, see
\code{\link[=fitted_draws]{fitted_draws()}} and \code{\link[=predict_draws]{predict_draws()}} to understand the difference between
fitted and predicted values.
}
\examples{

\donttest{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model is fit to 
# the 'berkeley_exdata' and saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether the model fit object 'berkeley_exfit' exists
berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# Population average distance and velocity curves with default options
plot_curves(model, opt = 'dv')

# Individual-specific distance and velocity curves with default options
# Note that \code{legendpos = 'none'} will suppress the legend positions. 
# This suppression is useful when plotting individual-specific curves

plot_curves(model, opt = 'DV')

# Population average distance and velocity curves with APGV

plot_curves(model, opt = 'dv', apv = TRUE)

# Individual-specific distance and velocity curves with APGV

plot_curves(model, opt = 'DV', apv = TRUE)

# Population average distance curve, velocity curve, and APGV with CI bands
# To construct CI bands, growth parameters are first calculated for each  
# posterior draw and then summarized across draws. Therefore,summary 
# option must be set to FALSE

plot_curves(model, opt = 'dv', apv = TRUE, bands = 'dvp', summary = FALSE)

# Adjusted and unadjusted individual curves
# Note ipts = NULL (i.e., no interpolation of predictor (i.e., age) to plot a 
# smooth curve). This is because it does not a make sense to interploate data 
# when estimating adjusted curves. Also, layout = 'facet' (and not default 
# layout = 'single') is used for the ease of visualizing the plotted 
# adjusted and unadjusted individual curves. However, these lines can be 
# superimposed on each other by setting the set layout = 'single'.
# For other plots shown above, layout can be set as 'single' or 'facet'

# Separate plots for adjusted and unadjusted curves (layout = 'facet')
plot_curves(model, opt = 'au', ipts = NULL, layout = 'facet')

# Superimposed adjusted and unadjusted curves (layout = 'single')
plot_curves(model, opt = 'au', ipts = NULL, layout = 'single')

}

}
\seealso{
\code{\link[=growthparameters]{growthparameters()}} \code{\link[=fitted_draws]{fitted_draws()}} \code{\link[=predict_draws]{predict_draws()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
