% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_draws.R
\name{marginal_draws.bgmfit}
\alias{marginal_draws.bgmfit}
\alias{marginal_draws}
\title{Estimate growth curves}
\usage{
\method{marginal_draws}{bgmfit}(
  model,
  resp = NULL,
  dpar = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  newdata = NULL,
  datagrid = NULL,
  re_formula = NA,
  allow_new_levels = FALSE,
  sample_new_levels = "gaussian",
  parameter = NULL,
  xrange = 1,
  acg_velocity = 0.1,
  digits = 2,
  numeric_cov_at = NULL,
  aux_variables = NULL,
  levels_id = NULL,
  avg_reffects = NULL,
  idata_method = NULL,
  ipts = NULL,
  seed = 123,
  future = FALSE,
  future_session = "multisession",
  future_splits = NULL,
  future_method = "future",
  future_re_expose = NULL,
  usedtplyr = FALSE,
  usecollapse = TRUE,
  cores = NULL,
  fullframe = FALSE,
  average = FALSE,
  plot = FALSE,
  showlegends = NULL,
  variables = NULL,
  condition = NULL,
  deriv = 0,
  deriv_model = TRUE,
  method = "custom",
  marginals = NULL,
  pdrawso = FALSE,
  pdrawsp = FALSE,
  pdrawsh = FALSE,
  type = NULL,
  by = NULL,
  conf_level = 0.95,
  transform = NULL,
  byfun = NULL,
  wts = NULL,
  hypothesis = NULL,
  equivalence = NULL,
  constrats_by = NULL,
  constrats_at = NULL,
  reformat = NULL,
  estimate_center = NULL,
  estimate_interval = NULL,
  dummy_to_factor = NULL,
  verbose = FALSE,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  funlist = NULL,
  envir = NULL,
  ...
)

marginal_draws(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{resp}{A character string (default \code{NULL}) to specify the response
variable when processing posterior draws for \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{ndraws}{A positive integer indicating the number of posterior draws to
use in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer specifying the specific posterior draw(s) to use
in estimation (default \code{NULL}).}

\item{newdata}{An optional data frame for estimation. If \code{NULL}
(default), \code{newdata} is retrieved from the \code{model}.}

\item{datagrid}{A grid of user-specified values to be used in the
\code{newdata} argument of various functions in the \pkg{marginaleffects}
package. This allows you to define the regions of the predictor space
where you want to evaluate the quantities of interest. See
\code{\link[marginaleffects:datagrid]{marginaleffects::datagrid()}} for more details. By default, the
\code{datagrid} is set to \code{NULL}, meaning no custom grid is constructed.
To set a custom grid, the argument should either be a data frame created
using \code{\link[marginaleffects:datagrid]{marginaleffects::datagrid()}}, or a named list, which is internally
used for constructing the grid. For convenience, you can also pass an empty
list \code{datagrid = list()}, in which case essential arguments like
\code{model} and \code{newdata} are inferred from the respective arguments
specified elsewhere. Additionally, the first-level predictor (such as age)
and any covariates included in the model (e.g., gender) are automatically
inferred from the \code{model} object.}

\item{re_formula}{Option to indicate whether or not to include
individual/group-level effects in the estimation. When \code{NA} (default),
individual-level effects are excluded, and population average growth
parameters are computed. When \code{NULL}, individual-level effects are
included in the computation, and the resulting growth parameters are
individual-specific. In both cases (\code{NA} or \code{NULL}), continuous
and factor covariates are appropriately included in the estimation.
Continuous covariates are set to their means by default (see
\code{numeric_cov_at} for details), while factor covariates remain
unaltered, allowing for the estimation of covariate-specific population
average and individual-specific growth parameters.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), each posterior sample for a
new level is drawn from the posterior draws of a randomly chosen existing
level. Each posterior sample for a new level may be drawn from a different
existing level such that the resulting set of new posterior draws
represents the variation across existing levels. If \code{"gaussian"},
sample new levels from the (multivariate) normal distribution implied by the
group-level standard deviations and correlations. This options may be useful
for conducting Bayesian power analysis or predicting new levels in
situations where relatively few levels where observed in the old_data. If
\code{"old_levels"}, directly sample new levels from the existing levels,
where a new level is assigned all of the posterior draws of the same
(randomly chosen) existing level.}

\item{parameter}{A single character string or a character vector specifying
the growth parameter(s) to be estimated. Options include \code{'tgv'}
(takeoff growth velocity), \code{'atgv'} (age at takeoff growth velocity),
\code{'pgv'} (peak growth velocity), \code{'apgv'} (age at peak growth
velocity), \code{'cgv'} (cessation growth velocity), \code{'acgv'} (age at
cessation growth velocity), and \code{'all'}. If \code{parameter = NULL}
(default), age at peak growth velocity (\code{'apgv'}) is estimated. When
\code{parameter = 'all'}, all six parameters are estimated. Note that the
\code{'all'} option cannot be used when the \code{by} argument is set to
\code{TRUE}.}

\item{xrange}{An integer to set the predictor range (e.g., age) when
executing the interpolation via \code{ipts}. By default, \code{NULL} sets
the individual-specific predictor range. Setting \code{xrange = 1} applies
the same range for individuals within the same higher grouping variable
(e.g., study). Setting \code{xrange = 2} applies an identical range across
the entire sample. Alternatively, a numeric vector (e.g., \code{xrange =
  c(6, 20)}) can be provided to set the range within the specified values.}

\item{acg_velocity}{A real number specifying the percentage of peak growth
velocity to be used as the cessation velocity when estimating the
\code{cgv} and \code{acgv} growth parameters. The \code{acg_velocity}
should be greater than \code{0} and less than \code{1}. The default value
of \code{acg_velocity = 0.10} indicates that 10 percent of the peak growth
velocity will be used to calculate the cessation growth velocity and the
corresponding age at cessation velocity. For example, if the peak growth
velocity estimate is \code{10 mm/year}, then the cessation growth velocity
will be \code{1 mm/year}.}

\item{digits}{An integer (default \code{2}) to set the decimal places for
rounding the results using the \code{\link[base:Round]{base::round()}} function.}

\item{numeric_cov_at}{An optional (named list) argument to specify the value
of continuous covariate(s). The default \code{NULL} option sets the
continuous covariate(s) to their mean. Alternatively, a named list can be
supplied to manually set these values. For example, \code{numeric_cov_at =
  list(xx = 2)} will set the continuous covariate variable 'xx' to 2. The
argument \code{numeric_cov_at} is ignored when no continuous covariates are
included in the model.}

\item{aux_variables}{An optional argument to specify the variable(s) that can
be passed to the \code{ipts} argument (see below). This is useful when
fitting location-scale models and measurement error models. If
post-processing functions throw an error such as \code{variable 'x' not
  found in either 'data' or 'data2'}, consider using \code{aux_variables}.}

\item{levels_id}{An optional argument to specify the \code{ids} for the
hierarchical model (default \code{NULL}). It is used only when the model is
applied to data with three or more levels of hierarchy. For a two-level
model, \code{levels_id} is automatically inferred from the model fit. For
models with three or more levels, \code{levels_id} is inferred from the
model fit under the assumption that hierarchy is specified from the lowest
to the uppermost level, i.e., \code{id} followed by \code{study}, where
\code{id} is nested within \code{study}. However, it is not guaranteed that
\code{levels_id} is sorted correctly, so it is better to set it manually
when fitting a model with three or more levels of hierarchy.}

\item{avg_reffects}{An optional argument (default \code{NULL}) to calculate
(marginal/average) curves and growth parameters, such as APGV and PGV. If
specified, it must be a named list indicating the \code{over} (typically a
level 1 predictor, such as age), \code{feby} (fixed effects, typically a
factor variable), and \code{reby} (typically \code{NULL}, indicating that
parameters are integrated over the random effects). For example,
\code{avg_reffects = list(feby = 'study', reby = NULL, over = 'age')}.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of interpolation points is set by the \code{ipts} argument.
Available options for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}).
\itemize{
\item \emph{Method 1} (\code{'m1'}) is adapted from the \pkg{iapvbs} package
and is documented
\href{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}{here}.
\item \emph{Method 2} (\code{'m2'}) is based on the \pkg{JMbayes} package
and is documented
\href{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}{here}.
The \code{'m1'} method works by internally constructing the data frame
based on the model configuration, while the \code{'m2'} method uses the
exact data frame from the model fit, accessible via \code{fit$data}. If
\code{idata_method = NULL} (default), method \code{'m2'} is automatically
selected. Note that method \code{'m1'} may fail in certain cases,
especially when the model includes covariates (particularly in
\code{univariate_by} models). In such cases, it is recommended to use
method \code{'m2'}.
}}

\item{ipts}{An integer to set the length of the predictor variable for
generating a smooth velocity curve. If \code{NULL}, the original values are
returned. If an integer (e.g., \code{ipts = 10}, default), the predictor is
interpolated. Note that these interpolations do not alter the range of the
predictor when calculating population averages and/or individual-specific
growth curves.}

\item{seed}{An integer (default \code{123}) that is passed to the estimation
method to ensure reproducibility.}

\item{future}{A logical value (default \code{FALSE}) to specify whether or
not to perform parallel computations. If set to \code{TRUE}, the
\code{\link[future.apply:future_lapply]{future.apply::future_sapply()}} function is used to summarize the posterior
draws in parallel.}

\item{future_session}{A character string specifying the session type when
\code{future = TRUE}. The \code{'multisession'} (default) option sets the
multisession environment, while the \code{'multicore'} option sets up a
multicore session. Note that \code{'multicore'} is not supported on Windows
systems. For more details, see \code{\link[future.apply:future_lapply]{future.apply::future_sapply()}}.}

\item{future_splits}{A list (default \code{NULL}) that can be an unnamed
numeric list, a logical value, or a numeric vector of length 1 or 2. It is
used to split the processing of posterior draws into smaller subsets for
parallel computation.
\itemize{
\item If passed as a list (e.g., \code{future_splits = list(1:6, 7:10)}),
each sequence of
numbers is passed to the \code{draw_ids} argument.
\item If passed as a numeric vector (e.g., \code{future_splits = c(10, 2)}),
the first element
specifies the number of draws (see \code{draw_ids}) and the second element
indicates the number of splits. The splits are created using
\code{\link[parallel:splitIndices]{parallel::splitIndices()}}.
\item If passed as a numeric vector of length 1, the first element is
internally set as the
number of draws (\code{ndraws} or \code{draw_ids}) depending on which one
is not \code{NULL}.
\item If \code{TRUE}, a numeric vector for \code{future_splits} is created
based on the number
of draws (\code{ndraws}) and the number of cores (\code{cores}).
\item If \code{FALSE}, \code{future_splits} is ignored.
The use case for \code{future_splits} is to save memory and improve
performance, especially on \code{Linux} systems when \code{future::plan()}
is set to \code{multicore}. Note: on Windows systems, R processes may not
be freed automatically when using \code{'multisession'}. In such cases, the
R processes can be interrupted using \code{\link[installr:kill_all_Rscript_s]{installr::kill_all_Rscript_s()}}.
}}

\item{future_method}{A character string (default \code{'future'}) to specify
the method for parallel computation. Options include:
\itemize{
\item \code{'future'}: Uses \code{\link[future:future]{future::future()}} along with
\code{\link[future.apply:future_lapply]{future.apply::future_lapply()}} for parallel execution.
\item \code{'foreach'}: Uses \code{\link[foreach:foreach]{foreach::foreach()}} with the
\code{'dofuture'} function from the \code{doFuture} package for parallel
execution.
}}

\item{future_re_expose}{A logical (default \code{NULL}) to indicate whether
to re-expose \code{Stan} functions when \code{future = TRUE}. This is
especially relevant when \code{\link[future:plan]{future::plan()}} is set to \code{'multisession'},
as already exposed C++ \code{Stan} functions cannot be passed across
multiple sessions.
\itemize{
\item When \code{future_re_expose = NULL} (the default), \code{future_re_expose}
is automatically set to \code{TRUE} for the \code{'multisession'} plan.
\item It is advised to explicitly set \code{future_re_expose = TRUE} for speed
gains when using parallel processing with \code{future = TRUE}.
}}

\item{usedtplyr}{A logical (default \code{FALSE}) indicating whether to use
the \pkg{dtplyr} package for summarizing the draws. This package uses
\pkg{data.table} as a back-end. It is useful when the data has a large
number of observations. For typical use cases, it does not make a
significant performance difference. The \code{usedtplyr} argument is
evaluated only when \code{method = 'custom'}.}

\item{usecollapse}{A logical (default \code{FALSE}) to indicate whether to
use the \pkg{collapse} package for summarizing the draws.}

\item{cores}{The number of cores to be used for parallel computations if
\code{future = TRUE}. On non-Windows systems, this argument can be set
globally via the \code{mc.cores} option. By default, \code{NULL}, the
number of cores is automatically determined using
\code{\link[future:re-exports]{future::availableCores()}}, and it will use the maximum number of cores
available minus one (i.e., \code{future::availableCores() - 1}).}

\item{fullframe}{A logical value indicating whether to return a
\code{fullframe} object in which \code{newdata} is bound to the summary
estimates. Note that \code{fullframe} cannot be used with \code{summary =
  FALSE}, and it is only applicable when \code{idata_method = 'm2'}. A
typical use case is when fitting a \code{univariate_by} model. This option
is mainly for internal use.}

\item{average}{A logical indicating whether to internally call the
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} or \code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}}
function. If \code{FALSE} (default), \code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} is
called; otherwise, \code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}} is used when
\code{average = TRUE}.}

\item{plot}{A logical specifying whether to plot predictions by calling
\code{\link[marginaleffects:plot_predictions]{marginaleffects::plot_predictions()}} (\code{TRUE}) or not (\code{FALSE}).
If \code{FALSE} (default), \code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} or
\code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}} are called to compute predictions (see
\code{average} for details). Note that
\code{\link[marginaleffects:plot_predictions]{marginaleffects::plot_predictions()}} allows either \code{condition} or
\code{by} arguments, but not both. Therefore, when the \code{condition}
argument is not \code{NULL}, the \code{by} argument is set to \code{NULL}.
This step is required because \strong{marginal_draws()} automatically
assigns the \code{by} argument when the model includes a covariate.}

\item{showlegends}{A logical value to specify whether to show legends
(\code{TRUE}) or not (\code{FALSE}). If \code{NULL} (default), the value of
\code{showlegends} is internally set to \code{TRUE} if \code{re_formula =
  NA}, and \code{FALSE} if \code{re_formula = NULL}.}

\item{variables}{A named list specifying the level 1 predictor, such as
\code{age} or \code{time}, used for estimating growth parameters in the
current use case. The \code{variables} list is set via the \code{esp}
argument (default value is \code{1e-6}). If \code{variables} is
\code{NULL}, the relevant information is retrieved internally from the
\code{model}. Alternatively, users can define \code{variables} as a named
list, e.g., \code{variables = list('x' = 1e-6)} where \code{'x'} is the
level 1 predictor. By default, \code{variables = list('age' = 1e-6)} in the
\pkg{marginaleffects} package, as velocity is usually computed by
differentiating the distance curve using the \code{dydx} approach. When
using this default, the argument \code{deriv} is automatically set to
\code{0} and \code{deriv_model} to \code{FALSE}. If parameters are to be
estimated based on the model's first derivative, \code{deriv} must be set
to \code{1} and \code{variables} will be defined as \code{variables =
  list('age' = 0)}. Note that if the default behavior is used (\code{deriv =
  0} and \code{variables = list('x' = 1e-6)}), additional arguments cannot be
passed to \code{variables}. In contrast, when using an alternative approach
(\code{deriv = 0} and \code{variables = list('x' = 0)}), additional options
can be passed to the \code{\link[marginaleffects:comparisons]{marginaleffects::comparisons()}} and
\code{\link[marginaleffects:comparisons]{marginaleffects::avg_comparisons()}} functions.}

\item{condition}{Conditional predictions
\itemize{
\item Character vector (max length 4): Names of the predictors to display.
\item Named list (max length 4): List names correspond to predictors. List elements can be:
\itemize{
\item Numeric vector
\item Function which returns a numeric vector or a set of unique categorical values
\item Shortcut strings for common reference values: "minmax", "quartile", "threenum"
}
\item 1: x-axis. 2: color/shape. 3: facet (wrap if no fourth variable, otherwise cols of grid). 4: facet (rows of grid).
\item Numeric variables in positions 2 and 3 are summarized by Tukey's five numbers \code{?stats::fivenum}
}}

\item{deriv}{An integer to indicate whether to estimate the distance curve or
its derivative (i.e., velocity curve). The \code{deriv = 0} (default) is
for the distance curve, whereas \code{deriv = 1} is for the velocity curve.}

\item{deriv_model}{A logical value specifying whether to estimate the
velocity curve from the derivative function or by differentiating the
distance curve. Set \code{deriv_model = TRUE} for functions that require
the velocity curve, such as \code{growthparameters()} and
\code{plot_curves()}. Set it to \code{NULL} for functions that use the
distance curve (i.e., fitted values), such as \code{loo_validation()} and
\code{plot_ppc()}.}

\item{method}{A character string specifying the computation method: whether
to use the \pkg{marginaleffects} machinery at the post-draw stage, i.e.,
\code{\link[marginaleffects:comparisons]{marginaleffects::comparisons()}} (\code{method = 'pkg'}) or to use custom
functions for efficiency and speed (\code{method = 'custom'}, default).
Note that \code{method = 'custom'} is particularly useful when testing
hypotheses. Also, when \code{method = 'custom'},
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} is used internally instead of
\code{\link[marginaleffects:comparisons]{marginaleffects::comparisons()}}.}

\item{marginals}{A \code{list}, \code{data.frame}, or \code{tibble} returned
by the \pkg{marginaleffects} functions (default \code{NULL}). This is only
evaluated when \code{method = 'custom'}. The \code{marginals} can be the
output from \pkg{marginaleffects} functions or posterior draws from
\code{marginaleffects::posterior_draws()}. The \code{marginals} argument is
primarily used for internal purposes.}

\item{pdrawso}{A character string (default \code{FALSE}) to indicate whether
to return the original posterior draws for parameters. Options include:
\itemize{
\item \code{'return'}: returns the original posterior draws,
\item \code{'add'}: adds the original posterior draws to the outcome.
}
When \code{pdrawso = TRUE}, the default behavior is \code{pdrawso =
  'return'}. Note that the posterior draws are returned before calling
\code{\link[marginaleffects:posterior_draws]{marginaleffects::posterior_draws()}}.}

\item{pdrawsp}{A character string (default \code{FALSE}) to indicate whether
to return the posterior draws for parameters. Options include:
\itemize{
\item \code{'return'}: returns the posterior draws for parameters,
\item \code{'add'}: adds the posterior draws to the outcome.
}
When \code{pdrawsp = TRUE}, the default behavior is \code{pdrawsp =
  'return'}. The \code{pdrawsp} represent the parameter estimates for each of
the posterior samples, and the summary of these are the estimates returned.}

\item{pdrawsh}{A character string (default \code{FALSE}) to indicate whether
to return the posterior draws for parameter contrasts. Options include:
\itemize{
\item \code{'return'}: returns the posterior draws for contrasts.
}
The summary of posterior draws for parameters is the default returned
object. The \code{pdrawsh} represent the contrast estimates for each of the
posterior samples, and the summary of these are the contrast returned.}

\item{type}{string indicates the type (scale) of the predictions used to
compute contrasts or slopes. This can differ based on the model
type, but will typically be a string such as: "response", "link", "probs",
or "zero". When an unsupported string is entered, the model-specific list of
acceptable values is returned in an error message. When \code{type} is \code{NULL}, the
first entry in the error message is used by default.}

\item{by}{Aggregate unit-level estimates (aka, marginalize, average over). Valid inputs:
\itemize{
\item \code{FALSE}: return the original unit-level estimates.
\item \code{TRUE}: aggregate estimates for each term.
\item Character vector of column names in \code{newdata} or in the data frame produced by calling the function without the \code{by} argument.
\item Data frame with a \code{by} column of group labels, and merging columns shared by \code{newdata} or the data frame produced by calling the same function without the \code{by} argument.
\item See examples below.
\item For more complex aggregations, you can use the \code{FUN} argument of the \code{hypotheses()} function. See that function's documentation and the Hypothesis Test vignettes on the \code{marginaleffects} website.
}}

\item{conf_level}{numeric value between 0 and 1. Confidence level to use to build a confidence interval.}

\item{transform}{A function applied to individual draws from the posterior
distribution before computing summaries. The argument \code{transform} is
based on the \code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} function. This should not be
confused with \code{transform} from \code{\link[brms:posterior_predict.brmsfit]{brms::posterior_predict()}}, which is
now deprecated.}

\item{byfun}{A function such as \code{mean()} or \code{sum()} used to aggregate
estimates within the subgroups defined by the \code{by} argument. \code{NULL} uses the
\code{mean()} function. Must accept a numeric vector and return a single numeric
value. This is sometimes used to take the sum or mean of predicted
probabilities across outcome or predictor
levels. See examples section.}

\item{wts}{logical, string or numeric: weights to use when computing average predictions, contrasts or slopes. These weights only affect the averaging in \verb{avg_*()} or with the \code{by} argument, and not unit-level estimates. See \code{?weighted.mean}
\itemize{
\item string: column name of the weights variable in \code{newdata}. When supplying a column name to \code{wts}, it is recommended to supply the original data (including the weights variable) explicitly to \code{newdata}.
\item numeric: vector of length equal to the number of rows in the original data or in \code{newdata} (if supplied).
\item FALSE: Equal weights.
\item TRUE: Extract weights from the fitted object with \code{insight::find_weights()} and use them when taking weighted averages of estimates. Warning: \code{newdata=datagrid()} returns a single average weight, which is equivalent to using \code{wts=FALSE}
}}

\item{hypothesis}{specify a hypothesis test or custom contrast using a number , formula, string equation, vector, matrix, or function.
\itemize{
\item Number: The null hypothesis used in the computation of Z and p (before applying \code{transform}).
\item String: Equation to specify linear or non-linear hypothesis tests. If the terms in \code{coef(object)} uniquely identify estimates, they can be used in the formula. Otherwise, use \code{b1}, \code{b2}, etc. to identify the position of each parameter. The \verb{b*} wildcard can be used to test hypotheses on all estimates. If a named vector is used, the names are used as labels in the output. Examples:
\itemize{
\item \code{hp = drat}
\item \code{hp + drat = 12}
\item \code{b1 + b2 + b3 = 0}
\item \verb{b* / b1 = 1}
}
\item Formula: \code{lhs ~ rhs | group}
\itemize{
\item \code{lhs}
\itemize{
\item \code{ratio}
\item \code{difference}
\item Leave empty for default value
}
\item \code{rhs}
\itemize{
\item \code{pairwise} and \code{revpairwise}: pairwise differences between estimates in each row.
\item \code{reference}: differences between the estimates in each row and the estimate in the first row.
\item \code{sequential}: difference between an estimate and the estimate in the next row.
\item \code{meandev}: difference between an estimate and the mean of all estimates.
\item `meanotherdev: difference between an estimate and the mean of all other estimates, excluding the current one.
\item \code{poly}: polynomial contrasts, as computed by the \code{stats::contr.poly()} function.
\item \code{helmert}: Helmert contrasts, as computed by the \code{stats::contr.helmert()} function. Contrast 2nd level to the first, 3rd to the average of the first two, and so on.
\item \code{trt_vs_ctrl}: difference between the mean of estimates (except the first) and the first estimate.
\item \code{I(fun(x))}: custom function to manipulate the vector of estimates \code{x}. The function \code{fun()} can return multiple (potentially named) estimates.
}
\item \code{group} (optional)
\itemize{
\item Column name of \code{newdata}. Conduct hypothesis tests withing subsets of the data.
}
\item Examples:
\itemize{
\item \code{~ poly}
\item \code{~ sequential | groupid}
\item \code{~ reference}
\item \code{ratio ~ pairwise}
\item \code{difference ~ pairwise | groupid}
\item \code{~ I(x - mean(x)) | groupid}
\item \verb{~ I(\\(x) c(a = x[1], b = mean(x[2:3]))) | groupid}
}
}
\item Matrix or Vector: Each column is a vector of weights. The the output is the dot product between these vectors of weights and the vector of estimates. The matrix can have column names to label the estimates.
\item Function:
\itemize{
\item Accepts an argument \code{x}: object produced by a \code{marginaleffects} function or a data frame with column \code{rowid} and \code{estimate}
\item Returns a data frame with columns \code{term} and \code{estimate} (mandatory) and \code{rowid} (optional).
\item The function can also accept optional input arguments: \code{newdata}, \code{by}, \code{draws}.
\item This function approach will not work for Bayesian models or with bootstrapping. In those cases, it is easy to use \code{get_draws()} to extract and manipulate the draws directly.
}
\item See the Examples section below and the vignette: \url{https://marginaleffects.com/chapters/hypothesis.html}
}}

\item{equivalence}{Numeric vector of length 2: bounds used for the two-one-sided test (TOST) of equivalence, and for the non-inferiority and non-superiority tests. See Details section below.}

\item{constrats_by}{A character vector (default \code{NULL}) specifying the
variable(s) by which hypotheses (at the post-draw stage) should be tested.
Note that the variable(s) in \code{constrats_by} should be a subset of the
variables included in the \code{'by'} argument.}

\item{constrats_at}{A character vector (default \code{NULL}) specifying the
variable(s) at which hypotheses (at the post-draw stage) should be tested.
\code{constrats_at} is particularly useful when the number of rows in the
estimates is large because \pkg{marginaleffects} does not allow hypotheses
testing when the number of rows exceeds 25.}

\item{reformat}{A logical (default \code{TRUE}) indicating whether to
reformat the output returned by \code{marginaleffects} as a data frame.
Column names are redefined as \code{conf.low} to \code{Q2.5} and
\code{conf.high} to \code{Q97.5} (assuming \code{conf_int = 0.95}).
Additionally, some columns (\code{term}, \code{contrast}, etc.) are dropped
from the data frame.}

\item{estimate_center}{A character string (default \code{NULL}) specifying
how to center estimates: either \code{'mean'} or \code{'median'}. This
option sets the global options as follows:
\code{options("marginaleffects_posterior_center" = "mean")} or
\code{options("marginaleffects_posterior_center" = "median")}. These global
options are restored upon function exit using \code{\link[base:on.exit]{base::on.exit()}}.}

\item{estimate_interval}{A character string (default \code{NULL}) to specify
the type of credible intervals: \code{'eti'} for equal-tailed intervals or
\code{'hdi'} for highest density intervals. This option sets the global
options as follows: \code{options("marginaleffects_posterior_interval" =
  "eti")} or \code{options("marginaleffects_posterior_interval" = "hdi")},
and is restored on exit using \code{\link[base:on.exit]{base::on.exit()}}.}

\item{dummy_to_factor}{A named list (default \code{NULL}) to convert dummy
variables into a factor variable. The list must include the following
elements:
\itemize{
\item \code{factor.dummy}: A character vector of dummy variables to be
converted to factors.
\item \code{factor.name}: The name for the newly created factor variable
(default is \code{'factor.var'} if \code{NULL}).
\item \code{factor.level}: A vector specifying the factor levels.
If \code{NULL}, levels are taken from \code{factor.dummy}.
If \code{factor.level} is provided, its length must match
\code{factor.dummy}.
}}

\item{verbose}{A logical argument (default \code{FALSE}) to specify whether
to print information collected during the setup of the object(s).}

\item{expose_function}{A logical argument (default \code{FALSE}) to indicate
whether Stan functions should be exposed. If \code{TRUE}, any Stan
functions exposed during the model fit using \code{expose_function = TRUE}
in the \code{\link[=bsitar]{bsitar()}} function are saved and can be used in post-processing. By
default, \code{expose_function = FALSE} in post-processing functions,
except in \code{\link[=optimize_model]{optimize_model()}} where it is set to \code{NULL}. If
\code{NULL}, the setting is inherited from the original model fit. It must
be set to \code{TRUE} when adding \code{fit criteria} or \code{bayes_R2}
during model optimization.}

\item{usesavedfuns}{A logical value (default \code{NULL}) indicating whether
to use already exposed and saved Stan functions. This is typically set
automatically based on the \code{expose_functions} argument from the
\code{\link[=bsitar]{bsitar()}} call. Manual specification of \code{usesavedfuns} is rarely
needed and is intended for internal testing, as improper use can lead to
unreliable estimates.}

\item{clearenvfuns}{A logical value indicating whether to clear the exposed
Stan functions from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL}, \code{clearenvfuns} is set based on the value of
\code{usesavedfuns}: \code{TRUE} if \code{usesavedfuns = TRUE}, or
\code{FALSE} if \code{usesavedfuns = FALSE}.}

\item{funlist}{A list (default \code{NULL}) specifying function names. This
is rarely needed, as required functions are typically retrieved
automatically. A use case for \code{funlist} is when \code{sigma_formula},
\code{sigma_formula_gr}, or \code{sigma_formula_gr_str} use an external
function (e.g., \code{poly(age)}). The \code{funlist} should include
function names defined in the \code{globalenv()}. For functions needing
both distance and velocity curves (e.g., \code{plot_curves(..., opt =
  'dv')}), \code{funlist} must include two functions: one for the distance
curve and one for the velocity curve.}

\item{envir}{The environment used for function evaluation. The default is
\code{NULL}, which sets the environment to \code{parent.frame()}. Since
most post-processing functions rely on \pkg{brms}, it is recommended to set
\code{envir = globalenv()} or \code{envir = .GlobalEnv}, especially for
derivatives like velocity curves.}

\item{...}{Additional arguments passed to the \code{\link[brms:fitted.brmsfit]{brms::fitted.brmsfit()}}
function. Please see \code{brms::fitted.brmsfit()} for details on
various options available.}
}
\value{
An array of predicted mean response values. See
\link[brms:fitted.brmsfit]{brms::fitted.brmsfit} for details.
}
\description{
The \strong{marginal_draws()} function estimates and plots
growth curves (distance and velocity) by using the \pkg{marginaleffects}
package as a back-end. This function can compute growth curves (via
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}}), average growth curves (via
\code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}}), or plot growth curves (via
\code{\link[marginaleffects:plot_predictions]{marginaleffects::plot_predictions()}}). Please see
\href{https://marginaleffects.com/}{here} for details. Note that the
\pkg{marginaleffects} package is highly flexible, and therefore, it
is expected that the user has a strong understanding of its workings.
Furthermore, since \pkg{marginaleffects} is rapidly evolving, the
results obtained from the current implementation should be considered
experimental.
}
\details{
The \strong{marginal_draws()} function estimates fitted values (via
\code{\link[brms:fitted.brmsfit]{brms::fitted.brmsfit()}}) or the posterior draws from the posterior
distribution (via \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}) depending on the \code{type}
argument.
}
\examples{

\donttest{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether model fit object 'berkeley_exfit' exists
berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# Population average distance curve
marginal_draws(model, deriv = 0, re_formula = NA)

# Individual-specific distance curves
marginal_draws(model, deriv = 0, re_formula = NULL)

# Population average velocity curve
marginal_draws(model, deriv = 1, re_formula = NA)

# Individual-specific velocity curves
marginal_draws(model, deriv = 1, re_formula = NULL)
}

}
\seealso{
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}}
\code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}}
\code{\link[marginaleffects:plot_predictions]{marginaleffects::plot_predictions()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
