% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-icon.R
\name{bs_icon}
\alias{bs_icon}
\title{Use Bootstrap icons (as inline SVG)}
\usage{
bs_icon(
  name,
  size = "1em",
  class = NULL,
  title = NULL,
  a11y = c("auto", "deco", "sem", "none"),
  ...
)
}
\arguments{
\item{name}{The name of the Bootstrap icon. Whitespace is replaced with \code{-}
(that way, \code{"arrow up"} can be used to refer to the "actual name" of
\code{"arrow-up"}). For a searchable list of names, see \url{https://icons.getbootstrap.com/}}

\item{size}{Any valid CSS unit defining both the height and width of the
icon.}

\item{class}{Additional CSS classes to add to the \verb{<svg>} element. Consider
providing Bootstrap 5+ utility classes (e.g., \code{text-success}) here to
stylize the icon (but also note that those utility classes will only work
when Bootstrap 5+ is on the page).}

\item{title}{If provided (highly recommended), \code{a11y} defaults to \code{"sem"},
meaning the title is used for on-hover text and screen reader
announcements.}

\item{a11y}{Cases that distinguish the role of the icon and inform which
accessibility attributes to be used. Icons can either be \code{"deco"}
(decorative, the default case), \code{"sem"} (semantic), \code{"none"} (no
accessibility features). The default, \code{"auto"}, resolves to \code{"sem"} if a
\code{title} is provided (and \code{"deco"} otherwise).}

\item{...}{additional CSS properties (e.g., \code{margin}, \code{position}, etc.)
placed on the \verb{<svg>} tag.}
}
\value{
An \code{\link[htmltools:HTML]{htmltools::HTML()}} string containing the SVG icon.
}
\description{
Use Bootstrap icons (as inline SVG)
}
\examples{

up <- bs_icon("arrow-up-circle", size = "9em", class = "text-success")
up_fill <- bs_icon("arrow-up-circle-fill", size = "9em", class = "text-success")

# utility class will only apply with a modern version of Bootstrap
if (interactive() && requireNamespace('bslib')) {
  bslib::page_fluid(up, up_fill)
}

}
