% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averageposterior.R
\name{.averagePosterior}
\alias{.averagePosterior}
\title{Average Over Posterior Predictions}
\usage{
.averagePosterior(posterior, resample = 0L, seed = FALSE)
}
\arguments{
\item{posterior}{A posterior matrix type object. It is assumed that different
predictions to be averaged over are on different columns. Different posterior
draws are on different rows.}

\item{resample}{An integer indicating the number of
bootstrap resamples of the posterior predictions to
use when calculating summaries. Defaults to \code{0L}.
See the details section for more information as its implementation
is experimental and it may not operate as one would expect.}

\item{seed}{A seed for random number generation. Defaults to \code{FALSE},
which means no seed is set.
Only used if \code{resample} is a positive, non-zero integer.}
}
\value{
A vector of the averaged posterior.
}
\description{
Internal function that averages over posterior predictions
using either \code{\link[=rowMeans]{rowMeans()}} or \code{\link[=rowBootMeans]{rowBootMeans()}}, the latter
being useful to incorporate uncertainty from the
inputs being used to generate predictions.
}
\keyword{internal}
