% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbfs.R
\name{db_dbfs_list}
\alias{db_dbfs_list}
\title{DBFS List}
\usage{
db_dbfs_list(
  path,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{The path of the new file. The path should be the absolute DBFS
path (for example \verb{/mnt/my-file.txt}).}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
data.frame
}
\description{
List the contents of a directory, or details of the file.
}
\details{
When calling list on a large directory, the list operation will time out
after approximately 60 seconds.

We \strong{strongly} recommend using list only on
directories containing less than 10K files and discourage using the DBFS REST
API for operations that list more than 10K files. Instead, we recommend that
you perform such operations in the context of a cluster, using the File
system utility (\code{dbutils.fs}), which provides the same functionality without
timing out.
\itemize{
\item If the file or directory does not exist, this call throws an exception with
\code{RESOURCE_DOES_NOT_EXIST.}
}
}
\seealso{
Other DBFS API: 
\code{\link{db_dbfs_add_block}()},
\code{\link{db_dbfs_close}()},
\code{\link{db_dbfs_create}()},
\code{\link{db_dbfs_delete}()},
\code{\link{db_dbfs_get_status}()},
\code{\link{db_dbfs_mkdirs}()},
\code{\link{db_dbfs_move}()},
\code{\link{db_dbfs_put}()},
\code{\link{db_dbfs_read}()}
}
\concept{DBFS API}
