% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{create_element_style}
\alias{create_element_style}
\title{Create the style for BPMN element}
\usage{
create_element_style(
  elementIds,
  stroke_color = NULL,
  stroke_width = NULL,
  stroke_opacity = NULL,
  font_color = NULL,
  font_family = NULL,
  font_size = NULL,
  font_bold = NULL,
  font_italic = NULL,
  font_strike_through = NULL,
  font_underline = NULL,
  font_opacity = NULL,
  opacity = NULL
)
}
\arguments{
\item{elementIds}{The IDs of the BPMN elements to style.}

\item{stroke_color}{The stroke color for the element.
It can be any HTML color name or HEX code, or special keywords.}

\item{stroke_width}{The stroke width for the element, in pixels (1 to 50).
\itemize{
\item If the set value is less than 1, the used value is 1.
\item If the set value is greater than 50, the used value is 50.
\item To hide the stroke, set the \code{stroke_color} property to \code{none}.
}}

\item{stroke_opacity}{The stroke opacity for the element, ranging from 0 to 100.}

\item{font_color}{The font color for the element.
It can be any HTML color name or HEX code, or special keywords.}

\item{font_family}{The font family for the element.}

\item{font_size}{The font size for the element, in pixels.}

\item{font_bold}{Should the font be bold? (default: \code{FALSE})}

\item{font_italic}{Should the font be italic? (default: \code{FALSE})}

\item{font_strike_through}{Should the font have a strike-through style? (default: \code{FALSE})}

\item{font_underline}{Should the font be underlined? (default: \code{FALSE})}

\item{font_opacity}{The font opacity for the element, ranging from 0 to 100.}

\item{opacity}{The opacity for the element, ranging from 0 to 100.}
}
\value{
A list representing the style for the specified BPMN elements.
}
\description{
Internal function to create the correct style structure for the 'BPMN' element.
}
\section{Special keywords}{
\describe{
\item{\code{default}}{
\itemize{
\item This keyword allows you to reset a style property of the BPMN element to its initial value.
\item When applied to color properties, it bypasses the color specified in the 'BPMN' source if 'BPMN in Color' support is enabled. Instead, it uses the color defined in the default style of the 'BPMN' element..
}
}
\item{\code{inherit}}{Applies the value from the immediate parent element.}
\item{\code{none}}{No color (used to hide strokes). Not available for \code{font_color}.}
\item{\code{swimlane}}{Applies the value from the nearest parent element with type \code{ShapeBpmnElementKind.LANE} or \code{ShapeBpmnElementKind.POOL}.}
}
}

\section{Note}{
\subsection{Opacity properties}{
\itemize{
\item If the set value is less than 0, the used value is 0.
\item If the set value is greater than 100, the used value is 100.
}
}

\subsection{Warning: \code{stroke_width} property}{

Changing the stroke width of Activities may be misleading, as the default stroke widths have a meaning according to the 'BPMN' Specification.\cr
For example, updating the stroke width of a task using the same value as the default stroke width of a Call Activity can be confusing.\cr
In this case, you should also change another property, such as the stroke color, to allow the user to differentiate between them.
}
}

\keyword{internal}
