% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_separate_calls_linter.R
\name{box_separate_calls_linter}
\alias{box_separate_calls_linter}
\title{\code{box} library separate packages and module imports linter}
\usage{
box_separate_calls_linter()
}
\value{
A custom linter function for use with \code{r-lib/lintr}
}
\description{
Checks that packages and modules are imported in separate \code{box::use()} statements.
}
\details{
For use in \code{rhino}, see the
\href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Explanation: Rhino style guide}
to learn about the details.
}
\examples{
# will produce lints
lintr::lint(
  text = "box::use(package, path/to/file)",
  linters = box_separate_calls_linter()
)

lintr::lint(
  text = "box::use(path/to/file, package)",
  linters = box_separate_calls_linter()
)

# okay
lintr::lint(
  text = "box::use(package1, package2)
    box::use(path/to/file1, path/to/file2)",
  linters = box_separate_calls_linter()
)

}
