compare.tables <- function(full.res = NULL, 
                           true.labs = NULL, 
                           verbose = TRUE) {
  if (is.null(full.res)) stop("argument full.res missing with no default: input list generated from function compare.clusters")
  if (is.null(true.labs)) stop("argument true.labs missing with no default: input vector of true class labels")

  out <- list(
    kmeans = table(true.labs, full.res$km$cluster),
    bootkmeans = table(true.labs, full.res$bkm$clusters)
  )
  if (full.res$what == "all") out$fuzzcmeans <- table(true.labs, full.res$fkm$clus[, 1])
  if (verbose) {
    message("Kmeans") 
    print(out$kmeans)
    message("\nBootKmeans MAP-OOB") 
    print(out$bootkmeans)
    if (!is.null(out$fuzzcmeans)) {
      message("\nFuzzy C-Means MAP")
      print(out$fuzzkmeans)
    }
  }
  invisible(out) 
}
