% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuningModel.R
\name{bestEATBoost}
\alias{bestEATBoost}
\title{Tuning an EATBoost model}
\usage{
bestEATBoost(
  training,
  test,
  x,
  y,
  num.iterations,
  learning.rate,
  num.leaves,
  verbose = TRUE
)
}
\arguments{
\item{training}{Training \code{data.frame} or \code{matrix} containing the
variables for model construction.}

\item{test}{Test \code{data.frame} or \code{matrix} containing the variables
for model assessment.}

\item{x}{Column input indexes in \code{training}.}

\item{y}{Column output indexes in \code{training}.}

\item{num.iterations}{Maximum number of iterations the algorithm will perform}

\item{learning.rate}{Learning rate that control overfitting of the algorithm.
Value must be in (0,1]}

\item{num.leaves}{Maximum number of terminal leaves in each tree at each
iteration}

\item{verbose}{Controls the verbosity.}
}
\value{
A \code{data.frame} with the sets of hyperparameters and the root
mean squared error (RMSE) and mean square error (MSE) associated for each
model.
}
\description{
This function computes the root mean squared error (RMSE) for a
set of EATBoost models built with a grid of given hyperparameters.
}
