% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gumbel.R
\name{Gumbel}
\alias{Gumbel}
\title{Gumbel distribution}
\description{
A R6 class to represent a Gumbel distribution.
}
\details{
See \href{https://en.wikipedia.org/wiki/Gumbel_distribution}{Wikipedia}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{a}}{Get or set the value of \code{a}.}

\item{\code{b}}{Get or set the value of \code{b}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Gumbel-new}{\code{Gumbel$new()}}
\item \href{#method-Gumbel-d}{\code{Gumbel$d()}}
\item \href{#method-Gumbel-p}{\code{Gumbel$p()}}
\item \href{#method-Gumbel-q}{\code{Gumbel$q()}}
\item \href{#method-Gumbel-r}{\code{Gumbel$r()}}
\item \href{#method-Gumbel-mean}{\code{Gumbel$mean()}}
\item \href{#method-Gumbel-median}{\code{Gumbel$median()}}
\item \href{#method-Gumbel-mode}{\code{Gumbel$mode()}}
\item \href{#method-Gumbel-sd}{\code{Gumbel$sd()}}
\item \href{#method-Gumbel-variance}{\code{Gumbel$variance()}}
\item \href{#method-Gumbel-skewness}{\code{Gumbel$skewness()}}
\item \href{#method-Gumbel-kurtosis}{\code{Gumbel$kurtosis()}}
\item \href{#method-Gumbel-kurtosisExcess}{\code{Gumbel$kurtosisExcess()}}
\item \href{#method-Gumbel-clone}{\code{Gumbel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-new"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-new}{}}}
\subsection{Method \code{new()}}{
New Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$new(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{location parameter}

\item{\code{b}}{scale parameter, \code{>0}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Gumbel} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-d"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-d}{}}}
\subsection{Method \code{d()}}{
Density function of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$d(x, log = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{numeric vector}

\item{\code{log}}{Boolean, whether to return the logarithm of the density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The density or the log-density evaluated at \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-p"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-p}{}}}
\subsection{Method \code{p()}}{
Cumulative distribution function of the Gumbel
  distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$p(q, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{numeric vector of quantiles}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cumulative probabilities corresponding to \code{q}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-q"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-q}{}}}
\subsection{Method \code{q()}}{
Quantile function of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$q(p, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{numeric vector of probabilities}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The quantiles corresponding to \code{p}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-r"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-r}{}}}
\subsection{Method \code{r()}}{
Sampling from the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$r(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of simulations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector of length \code{n}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-mean"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-mean}{}}}
\subsection{Method \code{mean()}}{
Mean of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mean of the Gumbel distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-median"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-median}{}}}
\subsection{Method \code{median()}}{
Median of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$median()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The median of the Gumbel distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-mode"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-mode}{}}}
\subsection{Method \code{mode()}}{
Mode of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mode of the Gumbel distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-sd"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-sd}{}}}
\subsection{Method \code{sd()}}{
Standard deviation of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$sd()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The standard deviation of the Gumbel distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-variance"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-variance}{}}}
\subsection{Method \code{variance()}}{
Variance of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$variance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The variance of the Gumbel distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-skewness"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-skewness}{}}}
\subsection{Method \code{skewness()}}{
Skewness of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$skewness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The skewness of the Gumbel distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-kurtosis"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-kurtosis}{}}}
\subsection{Method \code{kurtosis()}}{
Kurtosis of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$kurtosis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis of the Gumbel distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-kurtosisExcess"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-kurtosisExcess}{}}}
\subsection{Method \code{kurtosisExcess()}}{
Kurtosis excess of the Gumbel distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$kurtosisExcess()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis excess of the Gumbel distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Gumbel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Gumbel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gumbel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
