% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/per_boo.R
\name{per_boo}
\alias{per_boo}
\title{Bootstrap of Periodogram}
\usage{
per_boo(x, B, taper0 = 0)
}
\arguments{
\item{x}{A vector or a time series.}

\item{B}{A positive integer; the number of bootstrap replications.}

\item{taper0}{A numeric value; specifies the proportion of data to taper.
The default value is 0, that is there is no tapering.}
}
\value{
A list containing:
\itemize{
\item \code{obj}: A list of class "boodd" containing the bootstrap periodograms.
\item \code{freqs}: A vector of Fourier frequencies used in the periodogram estimation.
}
}
\description{
Computes periodogram values at Fourier frequencies for a time series, smooths
the periodogram to estimate the spectral density, and generates the bootstrap
version of the periodogram.
}
\details{
The function first centers the input time series and calculates the values of
the periodogram
at Fourier frequencies using \code{spec.pgram}. Spectral density is then estimated by applying
a kernel smoother to the periodogram values, with the smoothing bandwidth computed as
\eqn{sd(x) * n^(-1/3)}. Bootstrap is then performed by resampling periodogram ordinates.

The function outputs a graph of the histogram of the periodogram ordinates which should be close to
an exponential density.
}
\examples{
set.seed(12345)
x=arima.sim(model=list(ar=0.8),n=200)
boo1=per_boo(x,99)

fn=length(boo1[[2]])
spec.pgram(x, plot=TRUE)
# Superimposed plots of 99 bootstrap periodograms
for ( i in (1:99)) {
lines(boo1[[2]],t(boo1[[1]]$s)[,i], type="l", col=i)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..

Bertail, P. and  Dudek, A.E. (2021). Consistency of the Frequency Domain
Bootstrap for differentiable functionals, \emph{Electron. J. Statist.}, \bold{15}, 1-36.

Hurvich, C. M. and Zeger, S. L. (1987). Frequency domain bootstrap
methods for time series, Technical Report 87-115, Graduate School of Business
Administration, New York Univ.

Lahiri, S.N. (2003). \emph{Resampling Methods for Dependent Data}. Springer,
New York.
}
\seealso{
\code{\link{tft_boot}}, \code{\link{func_fdb}}, \code{\link{freqboot}}.
}
\keyword{"Frequency}
\keyword{"Periodogram}
\keyword{Periodogram}
\keyword{bootstrap"}
\keyword{ordinates"}
