% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftrunc.R
\name{ftrunc}
\alias{ftrunc}
\title{Robust Estimators of the Mean Based on Regeneration Blocks.}
\usage{
ftrunc(x, atom_f, m = quantile(x, 0.05), M = quantile(x, 0.95), trunc)
}
\arguments{
\item{x}{A vector or time series.}

\item{atom_f}{A numeric value specifying an atom of the Markov chain.}

\item{m}{A numeric value; the lower truncation threshold
Default is the 5th percentile of \code{x}.}

\item{M}{A numeric value; the upper truncation threshold
Default is the 95th percentile of \code{x}.}

\item{trunc}{A numeric value specifying the truncation threshold for computing the
truncated and Winsorized means of the block length.}
}
\value{
A numeric vector containing the following elements:
\itemize{
\item \code{"taumean"} - the mean block size,
\item \code{"fmean"} - the mean of the input data,
\item \code{"fmed"} - the median of the input data,
\item \code{"tmean"} - the truncated mean of the blocks based on the truncation threshold,
\item \code{"wmean"} - the Winsorized mean of the blocks based on the truncation threshold.
}
}
\description{
The function calculates various statistics (mean, median, truncated, and Winsorized mean)
based on regeneration blocks obtained from the data. It also computes the mean block size.
It relies on block-based calculations for robust statistics by eliminating either too large blocks
or too large values of the mean on a given block.
}
\details{
This function uses blocks obtained from the input data \code{x} to compute
several descriptive statistics, including the mean size of blocks,
overall mean, median, and robust estimates like truncated and Winsorized means.
The function internally uses \code{\link{GetBlocks}} to divide the input data
into regenerative blocks when the process hits the atom \code{atom_f}.

The parameters \code{m} and \code{M} represent the lower and upper truncation
thresholds, respectively. By default, these are set to the 5th and 95th percentiles
of the input data, but they can be manually adjusted by the user to perform customized truncation.

The parameter \code{trunc} is used to eliminate blocks which lengths are greater than
\code{trunc}.
}
\examples{
n=500 # the length of the process
lambda=0.6 # arrival rate
mu=0.8 # departure rat
X = genMM1(n,lambda,mu) # generate MM1 queue
atom = 0 # specify the atom
trunc = 30 # set truncation threshold
result = ftrunc(x=X, atom_f=atom, m=0, trunc = trunc) # apply function
print(result)

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P., Clémençon, S. and  Tressou, J. (2015). Bootstrapping Robust Statistics
for Markovian Data Applications to Regenerative R‐Statistics and L‐Statistics.
\emph{Journal of Time Series Analysis}, \bold{36}, 462–480.
}
\seealso{
\code{\link{GetBlocks}}, \code{\link{findBestEpsilon}}, \code{\link{GetPseudoBlocks}},
\code{\link{smallEnsemble}},
\code{\link{regenboot}}.
}
\keyword{"Markov}
\keyword{"Regenerative}
\keyword{"Robust}
\keyword{Block}
\keyword{Bootstrap"}
\keyword{chains"}
\keyword{statistics"}
