% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field.sub.R
\name{field.sub}
\alias{field.sub}
\title{Subsampling of Random Fields}
\usage{
field.sub(arr, func, length.block, ...)
}
\arguments{
\item{arr}{A multidimensional real-valued array; it represents a random field on a grid of dimension
equals to dimension of the \code{arr}.}

\item{func}{A function applied to each subsample.
The function should accept the subsample as input and return a vector.}

\item{length.block}{An integer or vector of integers; it specified the block lengths for subsampling.
If a scalar is provided, the same block length is used for all dimensions}

\item{...}{An optional additional arguments for the \code{func} function.}
}
\value{
Returns a matrix or vector, depending on the output of the \code{func}
function. Each row in the matrix
corresponds to the result of applying \code{func} to a subsample.
Since it is not a \code{boodd} object, one cannot apply, for example,
the \code{confint} function to construct a confidence intervals (which depends on the rate of
convergence of the statistic of interest), see example below.
}
\description{
Performs subsampling of a multidimensional array representing a
random field on a lattice.
This function applies a specified function to each subsample.
}
\details{
The \code{field.sub} function is designed for subsampling a multidimensional array.
The \code{length.block} argument defines the size of each subsample. If \code{length.block}
is a scalar,
it applies uniformly across all dimensions of the array. Otherwise, it must
be a vector with a length equal to the number of dimensions in \code{arr}.
The function \code{func} is applied to each subsample,
and the results are returned in a matrix or vector, depending on the output of \code{func}.
}
\examples{
\donttest{
set.seed(1)
# 2-dims array
dlens <- c(100,50)
blens <- c(6,3)
arr <- array(round(rnorm(prod(dlens)),2),dim=dlens)
resu<-field.sub(arr,mean,blens)
hist(resu,nclass=25)
N=length(resu)
lB=length(blens)
conf=mean(arr)-(quantile(resu,c(0.025,0.975))-mean(arr))*sqrt(lB)/sqrt(N)
conf[2:1]
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Politis, D.N. Romano, J.P. Wolf, M.  (1999). \emph{Subsampling}, Springer, New York.
}
\seealso{
\code{\link{fieldboot}}, \code{\link{fieldbootP}}, \code{\link{blockboot}}, \code{\link{jackVarField}}.
}
\keyword{"Random}
\keyword{Bootstrap}
\keyword{Subsampling}
\keyword{fields"}
